/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.TextArea;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.matcher.Matchers;

public class TextAreaTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("TextArea.html");
    }

    @Test
    public void can_find_textArea_by_id() {
        ComponentFactory.component(TextArea.class, (By)By.$((String)"#textArea_1"));
        try {
            ComponentFactory.component(TextArea.class, (By)By.$((String)"#textArea_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#textArea_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_textArea() {
        try {
            ComponentFactory.component(TextArea.class, (By)By.$((String)"#abbr_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=abbr_ess1 is not a TextArea but a Abbr"));
        }
    }

    @Test
    public void test_textArea_coreAttributes() {
        TextArea textArea_1 = (TextArea)ComponentFactory.component(TextArea.class, (By)By.$((String)"#textArea_1"));
        Language.assertThat((Object)textArea_1.id(), (Matcher)org.hamcrest.Matchers.is((Object)"textArea_1"));
        Language.assertThat((Object)textArea_1.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"myTEXTAREAClass"));
        Language.assertThat((Object)textArea_1.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)textArea_1.title(), (Matcher)org.hamcrest.Matchers.is((Object)"textAreaTitle"));
    }

    @Test
    public void test_textArea_i18nAttributes() {
        TextArea textArea_1 = (TextArea)ComponentFactory.component(TextArea.class, (By)By.$((String)"#textArea_1"));
        Language.assertThat((Object)textArea_1.direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)textArea_1.language(), (Matcher)org.hamcrest.Matchers.is((Object)"en"));
    }

    @Test
    public void test_textArea_specifics_attributes() {
        TextArea textArea_1 = (TextArea)ComponentFactory.component(TextArea.class, (By)By.$((String)"#textArea_1"));
        Language.assertThat((Object)textArea_1.name(), (Matcher)org.hamcrest.Matchers.is((Object)"textAreaName"));
        Language.assertThat((Object)textArea_1.rows(), (Matcher)org.hamcrest.Matchers.is((Object)10));
        Language.assertThat((Object)textArea_1.cols(), (Matcher)org.hamcrest.Matchers.is((Object)50));
        Language.assertThat((Object)textArea_1.tabindex(), (Matcher)org.hamcrest.Matchers.is((Object)3));
        Language.assertThat((Object)textArea_1.accesskey(), (Matcher)org.hamcrest.Matchers.is((Object)"T"));
        Language.assertThat((Object)textArea_1.value(), (Matcher)org.hamcrest.Matchers.containsString((String)"First line of initial text"));
        Language.assertThat((Object)textArea_1.value(), (Matcher)org.hamcrest.Matchers.containsString((String)"Second line of initial text"));
    }

    @Test
    public void test_enability() {
        TextArea textArea_1 = (TextArea)ComponentFactory.component(TextArea.class, (By)By.$((String)"#textArea_1"));
        TextArea textArea_2 = (TextArea)ComponentFactory.component(TextArea.class, (By)By.$((String)"#textArea_2"));
        TextArea textArea_3 = (TextArea)ComponentFactory.component(TextArea.class, (By)By.$((String)"[name=textArea3linesName]"));
        Language.assertThat((Object)textArea_1, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.disabled())));
        Language.assertThat((Object)textArea_1, (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.enabled()));
        Language.assertThat((Object)textArea_1.isReadOnly(), (Matcher)org.hamcrest.Matchers.is((Object)false));
        Language.assertThat((Object)textArea_2.isReadOnly(), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Language.assertThat((Object)textArea_3, (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.disabled()));
        Language.assertThat((Object)textArea_3, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.enabled())));
    }

    @Test
    public void test_label() {
        Language.assertThat((Object)ComponentFactory.component(TextArea.class, (By)By.$((String)"#textArea_2")), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Text with two lines")));
        Language.assertThat((Object)((TextArea)ComponentFactory.component(TextArea.class, (By)By.$((String)"[name=textArea3linesName]"))).label(), (Matcher)org.hamcrest.Matchers.containsString((String)"Text with three lines"));
    }

    @Test
    public void test_toString() {
        TextArea textArea = (TextArea)ComponentFactory.component(TextArea.class, (By)By.$((String)"#textArea_1"));
        Language.assertThat((Object)textArea.toString(), (Matcher)org.hamcrest.Matchers.containsString((String)"class org.testatoo.cartridge.html4.element.TextArea with state : enabled:true, visible:true, value:First line of initial text."));
        Language.assertThat((Object)textArea.toString(), (Matcher)org.hamcrest.Matchers.containsString((String)"Second line of initial text., label:"));
    }
}

