/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.Selection;
import org.testatoo.core.component.datagrid.Cell;
import org.testatoo.core.component.datagrid.Column;
import org.testatoo.core.component.datagrid.DataGrid;
import org.testatoo.core.component.datagrid.Row;

public class DataGridTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("DataGrid.html");
    }

    @Test
    public void can_find_datagrid_by_id() {
        ComponentFactory.component(DataGrid.class, (String)"grid1");
        try {
            ComponentFactory.component(DataGrid.class, (String)"otherGrid");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by id=otherGrid"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_datagrid() {
        try {
            ComponentFactory.component(DataGrid.class, (String)"firstChoice");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=firstChoice is not a DataGrid but a CheckBox"));
        }
    }

    @Test
    public void can_test_columns_title() {
        DataGrid grid1 = (DataGrid)ComponentFactory.component(DataGrid.class, (String)"grid1");
        Language.assertThat((Object)grid1.columns().size(), (Matcher)Matchers.is((Object)3));
        Selection columns = grid1.columns();
        Language.assertThat((Object)((Column)columns.get(0)).title(), (Matcher)Matchers.is((Object)"Column1"));
        Language.assertThat((Object)((Column)columns.get(1)).title(), (Matcher)Matchers.is((Object)"Column2"));
        Language.assertThat((Object)((Column)columns.get(2)).title(), (Matcher)Matchers.is((Object)"Column3"));
    }

    @Test
    public void can_test_column_cells() {
        DataGrid grid1 = (DataGrid)ComponentFactory.component(DataGrid.class, (String)"grid1");
        Selection columns = grid1.columns();
        Language.assertThat((Object)((Column)columns.get(0)).cells().size(), (Matcher)Matchers.is((Object)3));
        Language.assertThat((Object)((Column)columns.get(1)).cells().size(), (Matcher)Matchers.is((Object)3));
        Language.assertThat((Object)((Column)columns.get(2)).cells().size(), (Matcher)Matchers.is((Object)3));
        Language.assertThat((Object)((Cell)((Column)columns.get(0)).cells().get(0)).value(), (Matcher)Matchers.is((Object)"value10"));
        Language.assertThat((Object)((Cell)((Column)columns.get(0)).cells().get(1)).value(), (Matcher)Matchers.is((Object)"value11"));
        Language.assertThat((Object)((Cell)((Column)columns.get(0)).cells().get(2)).value(), (Matcher)Matchers.is((Object)"value12"));
        Language.assertThat((Object)((Cell)((Column)columns.get(1)).cells().get(0)).value(), (Matcher)Matchers.is((Object)"value20"));
        Language.assertThat((Object)((Cell)((Column)columns.get(1)).cells().get(1)).value(), (Matcher)Matchers.is((Object)"value21"));
        Language.assertThat((Object)((Cell)((Column)columns.get(1)).cells().get(2)).value(), (Matcher)Matchers.is((Object)"value22"));
        Language.assertThat((Object)((Cell)((Column)columns.get(2)).cells().get(0)).value(), (Matcher)Matchers.is((Object)"value30"));
        Language.assertThat((Object)((Cell)((Column)columns.get(2)).cells().get(1)).value(), (Matcher)Matchers.is((Object)"value31"));
        Language.assertThat((Object)((Cell)((Column)columns.get(2)).cells().get(2)).value(), (Matcher)Matchers.is((Object)"value32"));
    }

    @Test
    public void can_test_row_cell() {
        DataGrid grid1 = (DataGrid)ComponentFactory.component(DataGrid.class, (String)"grid1");
        Selection rows = grid1.rows();
        Language.assertThat((Object)rows.size(), (Matcher)Matchers.is((Object)3));
        Language.assertThat((Object)((Row)rows.get(0)).cells().size(), (Matcher)Matchers.is((Object)3));
        Language.assertThat((Object)((Row)rows.get(1)).cells().size(), (Matcher)Matchers.is((Object)3));
        Language.assertThat((Object)((Row)rows.get(2)).cells().size(), (Matcher)Matchers.is((Object)3));
        Language.assertThat((Object)((Cell)((Row)rows.get(0)).cells().get(0)).value(), (Matcher)Matchers.is((Object)"value10"));
        Language.assertThat((Object)((Cell)((Row)rows.get(0)).cells().get(1)).value(), (Matcher)Matchers.is((Object)"value20"));
        Language.assertThat((Object)((Cell)((Row)rows.get(0)).cells().get(2)).value(), (Matcher)Matchers.is((Object)"value30"));
        Language.assertThat((Object)((Cell)((Row)rows.get(1)).cells().get(0)).value(), (Matcher)Matchers.is((Object)"value11"));
        Language.assertThat((Object)((Cell)((Row)rows.get(1)).cells().get(1)).value(), (Matcher)Matchers.is((Object)"value21"));
        Language.assertThat((Object)((Cell)((Row)rows.get(1)).cells().get(2)).value(), (Matcher)Matchers.is((Object)"value31"));
        Language.assertThat((Object)((Cell)((Row)rows.get(2)).cells().get(0)).value(), (Matcher)Matchers.is((Object)"value12"));
        Language.assertThat((Object)((Cell)((Row)rows.get(2)).cells().get(1)).value(), (Matcher)Matchers.is((Object)"value22"));
        Language.assertThat((Object)((Cell)((Row)rows.get(2)).cells().get(2)).value(), (Matcher)Matchers.is((Object)"value32"));
    }

    @Test
    public void test_toString() {
        DataGrid grid1 = (DataGrid)ComponentFactory.component(DataGrid.class, (String)"grid1");
        Language.assertThat((Object)grid1.toString(), (Matcher)Matchers.is((Object)"class org.testatoo.core.component.datagrid.DataGrid with state : enabled:true, visible:true, column(s):3, row(s):3"));
    }
}

