/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.Panel;

public class PanelTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Panel.html");
    }

    @Test
    public void can_find_panel_by_id() {
        ComponentFactory.component(Panel.class, (String)"panelId");
        try {
            ComponentFactory.component(Panel.class, (String)"otherPanel");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by id=otherPanel"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_panel() {
        try {
            ComponentFactory.component(Panel.class, (String)"radio");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=radio is not a Panel but a Radio"));
        }
    }

    @Test
    public void can_test_title() {
        Language.assertThat((Object)((Panel)ComponentFactory.component(Panel.class, (String)"panelId")).title(), (Matcher)Matchers.is((Object)"panelTitle"));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Panel)ComponentFactory.component(Panel.class, (String)"panelId")).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.core.component.Panel with state : enabled:true, visible:true, title:panelTitle"));
    }
}

