/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.PasswordField;
import org.testatoo.core.matcher.Matchers;

public class PasswordFieldTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("InputPassword.html");
    }

    @Test
    public void can_find_passwordField_by_id() {
        ComponentFactory.component(PasswordField.class, (String)"input_1");
        try {
            ComponentFactory.component(PasswordField.class, (String)"input_2");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by id=input_2"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_passwordField() {
        try {
            ComponentFactory.component(PasswordField.class, (String)"inputPasswordError");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=inputPasswordError is not a PasswordField but a CheckBox"));
        }
    }

    @Test
    public void can_test_max_length() {
        Language.assertThat((Object)((PasswordField)ComponentFactory.component(PasswordField.class, (String)"input_1")).maxLength(), (Matcher)org.hamcrest.Matchers.is((Object)10));
        Language.assertThat((Object)((PasswordField)ComponentFactory.component(PasswordField.class, (String)"password_1")).maxLength(), (Matcher)org.hamcrest.Matchers.is((Object)20));
    }

    @Test
    public void test_label() {
        Language.assertThat((Object)ComponentFactory.component(PasswordField.class, (String)"password"), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Password label")));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((PasswordField)ComponentFactory.component(PasswordField.class, (String)"password")).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.core.component.PasswordField with state : enabled:false, visible:true, value:passwordValue, label:Password label, maxLength:8"));
    }
}

