/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.testatoo.cartridge.html4.EvaluatorException;
import org.testatoo.cartridge.html4.HtmlEvaluator;
import org.testatoo.core.ComponentException;
import org.testatoo.core.Duration;
import org.testatoo.core.Language;

public abstract class By {
    public abstract String id(HtmlEvaluator var1);

    public abstract String id(HtmlEvaluator var1, Duration var2, Duration var3);

    public abstract List<String> ids(HtmlEvaluator var1);

    public abstract List<String> ids(HtmlEvaluator var1, Duration var2, Duration var3);

    public abstract String toString();

    public static By id(final String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot find component with a null id.");
        }
        return new By(){

            @Override
            public String id(HtmlEvaluator evaluator) {
                return this.id(evaluator, new Duration(2000L, TimeUnit.MILLISECONDS), new Duration(500L, TimeUnit.MILLISECONDS));
            }

            @Override
            public String id(HtmlEvaluator evaluator, Duration duration, Duration frequency) {
                return By.waitUntilId(evaluator, id, duration, frequency);
            }

            @Override
            public List<String> ids(HtmlEvaluator evaluator) {
                return this.ids(evaluator, new Duration(2000L, TimeUnit.MILLISECONDS), new Duration(500L, TimeUnit.MILLISECONDS));
            }

            @Override
            public List<String> ids(HtmlEvaluator evaluator, Duration duration, Duration frequency) {
                return Arrays.asList(By.waitUntilIds(evaluator, id, duration, frequency));
            }

            @Override
            public String toString() {
                return "by id=" + id;
            }
        };
    }

    public static By $(String jQueryExpression) {
        return By.$(jQueryExpression, Language.max((long)2L, (TimeUnit)TimeUnit.SECONDS));
    }

    public static By $(final String jQueryExpression, final Duration duration) {
        if (jQueryExpression == null) {
            throw new IllegalArgumentException("Cannot find component when jQueryExpression is null.");
        }
        return new By(){

            @Override
            public String id(HtmlEvaluator evaluator) {
                return this.id(evaluator, duration, Language.max((long)500L, (TimeUnit)TimeUnit.MILLISECONDS));
            }

            @Override
            public String id(HtmlEvaluator evaluator, Duration duration2, Duration frequency) {
                return By.waitUntilId(evaluator, "jquery:" + this.jQueryExpression(), duration2, frequency);
            }

            @Override
            public List<String> ids(HtmlEvaluator evaluator) {
                return this.ids(evaluator, duration, Language.max((long)500L, (TimeUnit)TimeUnit.MILLISECONDS));
            }

            @Override
            public List<String> ids(HtmlEvaluator evaluator, Duration duration2, Duration frequency) {
                return Arrays.asList(By.waitUntilIds(evaluator, "jquery:" + this.jQueryExpression(), duration2, frequency));
            }

            @Override
            public String toString() {
                return "by jQueryExpression=" + this.jQueryExpression();
            }

            private String jQueryExpression() {
                if (!jQueryExpression.startsWith("$")) {
                    return "$('" + jQueryExpression + "')";
                }
                return jQueryExpression;
            }
        };
    }

    @Deprecated
    public static By jQuery(String jQueryExpression) {
        return By.$(jQueryExpression, Language.max((long)2L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Deprecated
    public static By jQuery(String jQueryExpression, Duration duration) {
        return By.$(jQueryExpression, duration);
    }

    private static String waitUntilId(HtmlEvaluator evaluator, String expression, Duration duration, Duration frequency) {
        String[] ids = By.waitUntilIds(evaluator, expression, duration, frequency);
        if (ids.length > 1) {
            throw new ComponentException("Find more than one component defined by jQueryExpression=" + expression.substring(7));
        }
        return ids[0];
    }

    private static String[] waitUntilIds(HtmlEvaluator evaluator, String expression, Duration duration, Duration frequency) {
        Exception ex = null;
        try {
            long step = frequency.unit.toMillis(frequency.duration);
            for (long timeout = duration.unit.toMillis(duration.duration); timeout > 0L && !Thread.currentThread().isInterrupted(); timeout -= step) {
                try {
                    return evaluator.elementsId(expression);
                }
                catch (RuntimeException e) {
                    ex = e;
                    Thread.sleep(step);
                    continue;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ex = e;
        }
        if (ex instanceof EvaluatorException) {
            if (expression.startsWith("jquery:")) {
                throw new ComponentException("Cannot find component defined by jQueryExpression=" + expression.substring(7));
            }
            throw new ComponentException("Cannot find component defined by id=" + expression);
        }
        throw new RuntimeException("Unable to reach the condition in " + duration.duration + " " + (Object)((Object)duration.unit), ex);
    }
}

