/**
 * Copyright (C) 2008 Ovea <dev@testatoo.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.testatoo.config.testatoo;

import com.mycila.log.Loggers;
import com.thoughtworks.selenium.Selenium;
import org.testatoo.core.CartridgeBootstraper;
import org.testatoo.core.EvaluatorHolder;

import java.util.ServiceLoader;

final class CartridgeConfiguratorBootstrapableSelenium implements CartridgeConfigurator<Selenium> {

    private static final CartridgeConfigurator<Selenium> INSTANCE = new CartridgeConfiguratorBootstrapableSelenium();

    private CartridgeConfiguratorBootstrapableSelenium() {
    }

    @Override
    public void configure(final Selenium session) {
        // only one cartridge per classpath, find first working evaluator
        for (CartridgeBootstraper bootstraper : ServiceLoader.load(CartridgeBootstraper.class)) {
            org.testatoo.core.Evaluator evaluator = bootstraper.init(session);
            if (evaluator != null) {
                Loggers.get(getClass()).info("Using cartridge boostrap: %s with evaluator %s", bootstraper.getClass().getName(), evaluator.getClass().getName());
                EvaluatorHolder.set(evaluator);
                return;
            }
        }
        throw new IllegalStateException("No CartridgeBootstraper service found in classpath. Be sure you have the good cartridge supporting Selenium in your classpath.");
    }

    public static CartridgeConfigurator<Selenium> get() {
        return INSTANCE;
    }
}