/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.config;

import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebResponse;
import com.ovea.tajin.server.ContainerConfiguration;
import com.ovea.tajin.server.Server;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.testatoo.config.AbstractTestatooModule;
import org.testatoo.config.Provider;
import org.testatoo.config.Scope;
import org.testatoo.config.TestatooModule;
import org.testatoo.config.container.ContainerConfig;
import org.testatoo.config.testatoo.Testatoo;

public final class ContainerTest {
    @Test
    public void test() throws Throwable {
        Testatoo testatoo = Testatoo.configure((TestatooModule[])new TestatooModule[]{new AbstractTestatooModule(){

            protected void configure() {
                Provider provider = this.createContainer().implementedBy(Server.JETTY9).webappRoot("src/test/webapp").context("/mycontext").port(7896).build();
                ((ContainerConfig)this.containers().register(provider).scope(Scope.TEST_CLASS)).register((Object)ContainerConfiguration.create().webappRoot("src/test/webapp").context("/mycontext").port(7897).buildContainer(Server.JETTY9)).scope(Scope.TEST_CLASS);
            }
        }});
        Assert.assertTrue((String)"Verify that port 7896 is free", (boolean)this.isPortFree(7896));
        Assert.assertTrue((String)"Verify that port 7897 is free", (boolean)this.isPortFree(7897));
        testatoo.start();
        Assert.assertFalse((String)"Verify that port 7896 is used", (boolean)this.isPortFree(7896));
        Assert.assertFalse((String)"Verify that port 7897 is used", (boolean)this.isPortFree(7897));
        this.verify("http://127.0.0.1:7896/mycontext/index.xhtml");
        this.verify("http://127.0.0.1:7897/mycontext/index.xhtml");
        testatoo.stop();
        Assert.assertTrue((String)"Verify that port 7896 is free", (boolean)this.isPortFree(7896));
        Assert.assertTrue((String)"Verify that port 7897 is free", (boolean)this.isPortFree(7897));
    }

    private void verify(String url) throws Exception {
        WebConversation wc = new WebConversation();
        WebResponse resp = wc.getResponse(url);
        Assert.assertEquals((Object)resp.getTitle(), (Object)"HTML file");
        Assert.assertThat((Object)resp.getText(), (Matcher)Matchers.containsString((String)"HTML file"));
    }

    private boolean isPortFree(int port) {
        try {
            ServerSocket server = ServerSocketFactory.getDefault().createServerSocket(port);
            server.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

