/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.config;

import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import org.junit.Assert;
import org.junit.Test;
import org.testatoo.config.AbstractTestatooModule;
import org.testatoo.config.Provider;
import org.testatoo.config.Scope;
import org.testatoo.config.TestatooModule;
import org.testatoo.config.selenium.SeleniumServerConfig;
import org.testatoo.config.testatoo.Testatoo;
import org.testatoo.selenium.server.SeleniumServerFactory;

public final class SeleniumServerTest {
    @Test
    public void test() throws Throwable {
        Testatoo testatoo = Testatoo.configure((TestatooModule[])new TestatooModule[]{new AbstractTestatooModule(){

            protected void configure() {
                Provider provider = this.createSeleniumServer().port(4444).build();
                ((SeleniumServerConfig)this.seleniumServers().register(provider).scope(Scope.TEST_CLASS)).register((Object)SeleniumServerFactory.commandeLine((String[])new String[]{"-port", "5555"}).create()).scope(Scope.TEST_CLASS);
            }
        }});
        Assert.assertTrue((String)"Verify that port 4444 is free", (boolean)this.isPortFree(4444));
        Assert.assertTrue((String)"Verify that port 5555 is free", (boolean)this.isPortFree(5555));
        testatoo.start();
        Assert.assertFalse((String)"Verify that port 4444 is used", (boolean)this.isPortFree(4444));
        Assert.assertFalse((String)"Verify that port 5555 is used", (boolean)this.isPortFree(5555));
        testatoo.stop();
        Assert.assertTrue((String)"Verify that port 4444 is free", (boolean)this.isPortFree(4444));
        Assert.assertTrue((String)"Verify that port 5555 is free", (boolean)this.isPortFree(5555));
    }

    private boolean isPortFree(int port) {
        try {
            ServerSocket server = ServerSocketFactory.getDefault().createServerSocket(port);
            server.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

