/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.azure;

import org.testcontainers.azure.AzuriteContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.LicenseAcceptance;

public class EventHubsEmulatorContainer
extends GenericContainer<EventHubsEmulatorContainer> {
    private static final int DEFAULT_AMQP_PORT = 5672;
    private static final String CONNECTION_STRING_FORMAT = "Endpoint=sb://%s:%d;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=SAS_KEY_VALUE;UseDevelopmentEmulator=true;";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"mcr.microsoft.com/azure-messaging/eventhubs-emulator");
    private AzuriteContainer azuriteContainer;

    public EventHubsEmulatorContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public EventHubsEmulatorContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Emulator Service is Successfully Up!.*", (int)1));
        this.withExposedPorts(new Integer[]{5672});
    }

    public EventHubsEmulatorContainer withAzuriteContainer(AzuriteContainer azuriteContainer) {
        this.azuriteContainer = azuriteContainer;
        this.dependsOn(new Startable[]{this.azuriteContainer});
        return this;
    }

    public EventHubsEmulatorContainer withConfig(Transferable config) {
        this.withCopyToContainer(config, "/Eventhubs_Emulator/ConfigFiles/Config.json");
        return this;
    }

    public EventHubsEmulatorContainer acceptLicense() {
        this.withEnv("ACCEPT_EULA", "Y");
        return this;
    }

    protected void configure() {
        if (this.azuriteContainer == null) {
            throw new IllegalStateException("The image " + this.getDockerImageName() + " requires an Azurite container. Please provide one with the withAzuriteContainer method!");
        }
        String azuriteHost = (String)this.azuriteContainer.getNetworkAliases().get(0);
        this.withEnv("BLOB_SERVER", azuriteHost);
        this.withEnv("METADATA_SERVER", azuriteHost);
        if (!this.getEnvMap().containsKey("ACCEPT_EULA")) {
            LicenseAcceptance.assertLicenseAccepted((String)this.getDockerImageName());
            this.acceptLicense();
        }
    }

    public String getConnectionString() {
        return String.format(CONNECTION_STRING_FORMAT, this.getHost(), this.getMappedPort(5672));
    }
}

