/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.cassandra;

import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.cassandra.CassandraContainer;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.ExecConfig;
import org.testcontainers.delegate.AbstractDatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;

public class CassandraDatabaseDelegate
extends AbstractDatabaseDelegate<Void> {
    private static final Logger log = LoggerFactory.getLogger(CassandraDatabaseDelegate.class);
    private final ContainerState container;

    protected Void createNewConnection() {
        return null;
    }

    public void execute(String statement, String scriptPath, int lineNumber, boolean continueOnError, boolean ignoreFailedDrops, boolean silentErrorLogs) {
        block9: {
            try {
                Object[] cqlshCommand = new String[]{"cqlsh"};
                if (this.container instanceof CassandraContainer) {
                    CassandraContainer cassandraContainer = (CassandraContainer)this.container;
                    String username = cassandraContainer.getUsername();
                    String password = cassandraContainer.getPassword();
                    if (cassandraContainer.isSslRequired()) {
                        cqlshCommand = (String[])ArrayUtils.add((Object[])cqlshCommand, (Object)"--ssl");
                    }
                    cqlshCommand = (String[])ArrayUtils.addAll((Object[])cqlshCommand, (Object[])new String[]{"-u", username, "-p", password});
                }
                String executeArg = "-e";
                String executeArgValue = statement;
                if (StringUtils.isBlank((CharSequence)statement)) {
                    executeArg = "-f";
                    executeArgValue = scriptPath;
                }
                cqlshCommand = (String[])ArrayUtils.addAll((Object[])cqlshCommand, (Object[])new String[]{executeArg, executeArgValue});
                Container.ExecResult result = this.container.execInContainer(ExecConfig.builder().command((String[])cqlshCommand).build());
                if (result.getExitCode() == 0) {
                    if (StringUtils.isBlank((CharSequence)statement)) {
                        log.info("CQL script {} successfully executed", (Object)scriptPath);
                    } else {
                        log.info("CQL statement {} was applied", (Object)statement);
                    }
                    break block9;
                }
                if (!silentErrorLogs) {
                    log.error("CQL script execution failed with error: \n{}", (Object)result.getStderr());
                }
                throw new ScriptUtils.ScriptStatementFailedException(statement, lineNumber, scriptPath);
            }
            catch (IOException | InterruptedException e) {
                throw new ScriptUtils.ScriptStatementFailedException(statement, lineNumber, scriptPath, e);
            }
        }
    }

    public void execute(String statement, String scriptPath, int lineNumber, boolean continueOnError, boolean ignoreFailedDrops) {
        this.execute(statement, scriptPath, lineNumber, continueOnError, ignoreFailedDrops, false);
    }

    protected void closeConnectionQuietly(Void session) {
    }

    public CassandraDatabaseDelegate(ContainerState container) {
        this.container = container;
    }
}

