/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.exporter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.Archive;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.ArchivePath;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.Node;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.exporter.AbstractExporterDelegate;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplodedExporterDelegate
extends AbstractExporterDelegate<File> {
    private static final Logger log = Logger.getLogger(ExplodedExporterDelegate.class.getName());
    private final File outputDirectory;

    public ExplodedExporterDelegate(Archive<?> archive, File outputDirectory) {
        super(archive);
        this.outputDirectory = outputDirectory;
        this.validateOutputDirectory(outputDirectory);
    }

    @Override
    protected void processNode(ArchivePath path, Node node) {
        block9: {
            String assetFilePath = path.get();
            File assetFile = new File(this.outputDirectory, assetFilePath);
            File assetParent = assetFile.getParentFile();
            if (!assetParent.exists() && !assetParent.mkdirs()) {
                throw new ArchiveExportException("Failed to write asset.  Unable to create parent directory.");
            }
            if (node != null && node.getAsset() instanceof ArchiveAsset) {
                ArchiveAsset nesteArchiveAsset = (ArchiveAsset)ArchiveAsset.class.cast(node.getAsset());
                this.processArchiveAsset(assetParent, nesteArchiveAsset);
                return;
            }
            try {
                boolean isDirectory;
                boolean bl = isDirectory = node.getAsset() == null;
                if (isDirectory) {
                    if (!assetFile.exists() && !assetFile.mkdirs()) {
                        throw new ArchiveExportException("Failed to write directory: " + assetFile.getAbsolutePath());
                    }
                    break block9;
                }
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Writing asset " + path.get() + " to " + assetFile.getAbsolutePath());
                    }
                    InputStream assetInputStream = node.getAsset().openStream();
                    FileOutputStream assetFileOutputStream = new FileOutputStream(assetFile);
                    BufferedOutputStream assetBufferedOutputStream = new BufferedOutputStream(assetFileOutputStream, 8192);
                    IOUtil.copyWithClose(assetInputStream, assetBufferedOutputStream);
                }
                catch (Exception e) {
                    throw new ArchiveExportException("Failed to write asset " + path + " to " + assetFile, e);
                }
            }
            catch (Exception e) {
                throw new ArchiveExportException("Unexpected error encountered in export of " + node, e);
            }
        }
    }

    @Override
    protected File getResult() {
        return this.outputDirectory;
    }

    private void processArchiveAsset(File parentDirectory, ArchiveAsset nestedArchiveAsset) {
        Archive<?> nestedArchive = nestedArchiveAsset.getArchive();
        nestedArchive.as(ExplodedExporter.class).exportExploded(parentDirectory);
    }

    private File validateOutputDirectory(File outputDirectory) {
        if (!outputDirectory.mkdir() && !outputDirectory.exists()) {
            throw new ArchiveExportException("Unable to create archive output directory - " + outputDirectory);
        }
        if (outputDirectory.isFile()) {
            throw new IllegalArgumentException("Unable to export exploded directory to " + outputDirectory.getAbsolutePath() + ", it points to a existing file");
        }
        return outputDirectory;
    }
}

