/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.milvus;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class MilvusContainer
extends GenericContainer<MilvusContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"milvusdb/milvus");
    private String etcdEndpoint;

    public MilvusContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public MilvusContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{9091, 19530});
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/healthz").forPort(9091));
        this.withCommand(new String[]{"milvus", "run", "standalone"});
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"testcontainers/embedEtcd.yaml"), "/milvus/configs/embedEtcd.yaml");
        this.withEnv("COMMON_STORAGETYPE", "local");
    }

    protected void configure() {
        if (this.etcdEndpoint == null) {
            this.withEnv("ETCD_USE_EMBED", "true");
            this.withEnv("ETCD_DATA_DIR", "/var/lib/milvus/etcd");
            this.withEnv("ETCD_CONFIG_PATH", "/milvus/configs/embedEtcd.yaml");
        } else {
            this.withEnv("ETCD_ENDPOINTS", this.etcdEndpoint);
        }
    }

    public MilvusContainer withEtcdEndpoint(String etcdEndpoint) {
        this.etcdEndpoint = etcdEndpoint;
        return this;
    }

    public String getEndpoint() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(19530);
    }
}

