/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.orientdb;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import lombok.NonNull;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class OrientDBContainer
extends GenericContainer<OrientDBContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"orientdb");
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "admin";
    private static final String DEFAULT_SERVER_USER = "root";
    private static final String DEFAULT_SERVER_PASSWORD = "root";
    private static final String DEFAULT_DATABASE_NAME = "testcontainers";
    private static final int DEFAULT_BINARY_PORT = 2424;
    private static final int DEFAULT_HTTP_PORT = 2480;
    private String databaseName;
    private String serverPassword;
    private Transferable scriptPath;

    public OrientDBContainer(@NonNull String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
    }

    public OrientDBContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.serverPassword = "root";
        this.databaseName = DEFAULT_DATABASE_NAME;
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*OrientDB Studio available.*", (int)1));
        this.addExposedPorts(new int[]{2424, 2480});
    }

    protected void configure() {
        this.addEnv("ORIENTDB_ROOT_PASSWORD", this.serverPassword);
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        try {
            String createDb = String.format("CREATE DATABASE remote:localhost/%s %s %s plocal; CONNECT remote:localhost/%s %s %s; CREATE USER %s IDENTIFIED BY %s ROLE admin;", this.databaseName, "root", this.serverPassword, this.databaseName, "root", this.serverPassword, "admin", "admin");
            this.execInContainer(new String[]{"/orientdb/bin/console.sh", createDb});
            if (this.scriptPath != null) {
                this.copyFileToContainer(this.scriptPath, "/opt/testcontainers/script.osql");
                String loadScript = String.format("CONNECT remote:localhost/%s %s %s; LOAD SCRIPT /opt/testcontainers/script.osql", this.databaseName, "root", this.serverPassword);
                this.execInContainer(new String[]{"/orientdb/bin/console.sh", loadScript});
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public OrientDBContainer withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (OrientDBContainer)this.self();
    }

    public OrientDBContainer withServerPassword(String serverPassword) {
        this.serverPassword = serverPassword;
        return (OrientDBContainer)this.self();
    }

    public OrientDBContainer withScriptPath(Transferable scriptPath) {
        this.scriptPath = scriptPath;
        return (OrientDBContainer)this.self();
    }

    public String getServerUrl() {
        return "remote:" + this.getHost() + ":" + this.getMappedPort(2424);
    }

    public String getDbUrl() {
        return this.getServerUrl() + "/" + this.databaseName;
    }

    public String getServerUser() {
        return "root";
    }

    public String getServerPassword() {
        return this.serverPassword;
    }

    public String getUsername() {
        return "admin";
    }

    public String getPassword() {
        return "admin";
    }
}

