/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.r2dbc;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import org.testcontainers.r2dbc.R2DBCDatabaseContainerProvider;
import org.testcontainers.r2dbc.TestcontainersR2DBCConnectionFactory;

class Hidden {
    Hidden() {
    }

    public static final class TestcontainersR2DBCConnectionFactoryProvider
    implements ConnectionFactoryProvider {
        public static final String DRIVER = "tc";

        public ConnectionFactory create(ConnectionFactoryOptions options) {
            options = this.sanitize(options);
            options = this.removeProxying(options);
            return new TestcontainersR2DBCConnectionFactory(options);
        }

        private ConnectionFactoryOptions sanitize(ConnectionFactoryOptions options) {
            ConnectionFactoryOptions.Builder builder = options.mutate();
            Object reusable = options.getValue(R2DBCDatabaseContainerProvider.REUSABLE_OPTION);
            if (reusable instanceof String) {
                builder.option(R2DBCDatabaseContainerProvider.REUSABLE_OPTION, (Object)Boolean.valueOf((String)reusable));
            }
            return builder.build();
        }

        private ConnectionFactoryOptions removeProxying(ConnectionFactoryOptions options) {
            String protocol = (String)options.getRequiredValue(ConnectionFactoryOptions.PROTOCOL);
            if (protocol.trim().length() == 0) {
                throw new IllegalArgumentException("Invalid protocol: " + protocol);
            }
            String[] protocols = protocol.split(":", 2);
            String driverDelegate = protocols[0];
            String protocolDelegate = protocols.length == 2 ? protocols[1] : "";
            return ConnectionFactoryOptions.builder().from(options).option(ConnectionFactoryOptions.DRIVER, (Object)driverDelegate).option(ConnectionFactoryOptions.PROTOCOL, (Object)protocolDelegate).build();
        }

        public boolean supports(ConnectionFactoryOptions options) {
            return DRIVER.equals(options.getValue(ConnectionFactoryOptions.DRIVER));
        }

        public String getDriver() {
            return DRIVER;
        }
    }
}

