/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.core;

import org.testcontainers.shaded.freemarker.core.Environment;
import org.testcontainers.shaded.freemarker.core.Expression;
import org.testcontainers.shaded.freemarker.core.ParameterRole;
import org.testcontainers.shaded.freemarker.core.StopException;
import org.testcontainers.shaded.freemarker.core.TemplateElement;
import org.testcontainers.shaded.freemarker.template.TemplateException;

final class StopInstruction
extends TemplateElement {
    private Expression exp;

    StopInstruction(Expression exp) {
        this.exp = exp;
    }

    @Override
    TemplateElement[] accept(Environment env) throws TemplateException {
        if (this.exp == null) {
            throw new StopException(env);
        }
        throw new StopException(env, this.exp.evalAndCoerceToPlainText(env));
    }

    @Override
    protected String dump(boolean canonical) {
        StringBuilder sb = new StringBuilder();
        if (canonical) {
            sb.append('<');
        }
        sb.append(this.getNodeTypeSymbol());
        if (this.exp != null) {
            sb.append(' ');
            sb.append(this.exp.getCanonicalForm());
        }
        if (canonical) {
            sb.append("/>");
        }
        return sb.toString();
    }

    @Override
    String getNodeTypeSymbol() {
        return "#stop";
    }

    @Override
    int getParameterCount() {
        return 1;
    }

    @Override
    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.exp;
    }

    @Override
    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.MESSAGE;
    }

    @Override
    boolean isNestedBlockRepeater() {
        return false;
    }
}

