/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.ext.jakarta.jsp;

import jakarta.el.ELContext;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspApplicationContext;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.JspFactory;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.el.ELException;
import jakarta.servlet.jsp.el.ExpressionEvaluator;
import jakarta.servlet.jsp.el.VariableResolver;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import org.testcontainers.shaded.freemarker.core.Environment;
import org.testcontainers.shaded.freemarker.ext.jakarta.jsp.FreeMarkerJspApplicationContext;
import org.testcontainers.shaded.freemarker.ext.jakarta.jsp.FreeMarkerJspFactory;
import org.testcontainers.shaded.freemarker.ext.jakarta.jsp.JspWriterAdapter;
import org.testcontainers.shaded.freemarker.ext.jakarta.jsp.TagTransformModel;
import org.testcontainers.shaded.freemarker.ext.jakarta.servlet.HttpRequestHashModel;
import org.testcontainers.shaded.freemarker.ext.jakarta.servlet.ServletContextHashModel;
import org.testcontainers.shaded.freemarker.ext.util.WrapperTemplateModel;
import org.testcontainers.shaded.freemarker.log.Logger;
import org.testcontainers.shaded.freemarker.template.AdapterTemplateModel;
import org.testcontainers.shaded.freemarker.template.ObjectWrapper;
import org.testcontainers.shaded.freemarker.template.ObjectWrapperAndUnwrapper;
import org.testcontainers.shaded.freemarker.template.TemplateBooleanModel;
import org.testcontainers.shaded.freemarker.template.TemplateDateModel;
import org.testcontainers.shaded.freemarker.template.TemplateHashModelEx;
import org.testcontainers.shaded.freemarker.template.TemplateModel;
import org.testcontainers.shaded.freemarker.template.TemplateModelException;
import org.testcontainers.shaded.freemarker.template.TemplateModelIterator;
import org.testcontainers.shaded.freemarker.template.TemplateNumberModel;
import org.testcontainers.shaded.freemarker.template.TemplateScalarModel;
import org.testcontainers.shaded.freemarker.template._VersionInts;
import org.testcontainers.shaded.freemarker.template.utility.ClassUtil;
import org.testcontainers.shaded.freemarker.template.utility.UndeclaredThrowableException;

class FreeMarkerPageContext
extends PageContext
implements TemplateModel {
    private static final Logger LOG = Logger.getLogger("freemarker.jsp");
    private final Environment environment;
    private final int incompatibleImprovements;
    private List tags = new ArrayList();
    private List outs = new ArrayList();
    private final GenericServlet servlet;
    private HttpSession session;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ObjectWrapper wrapper;
    private final ObjectWrapperAndUnwrapper unwrapper;
    private JspWriter jspOut;
    private ELContext elContext;

    protected FreeMarkerPageContext() throws TemplateModelException {
        this.environment = Environment.getCurrentEnvironment();
        this.incompatibleImprovements = this.environment.getConfiguration().getIncompatibleImprovements().intValue();
        TemplateModel appModel = this.environment.getGlobalVariable("__FreeMarkerServlet.Application__");
        if (!(appModel instanceof ServletContextHashModel)) {
            appModel = this.environment.getGlobalVariable("Application");
        }
        if (!(appModel instanceof ServletContextHashModel)) {
            throw new TemplateModelException("Could not find an instance of " + ServletContextHashModel.class.getName() + " in the data model under either the name " + "__FreeMarkerServlet.Application__" + " or " + "Application");
        }
        this.servlet = ((ServletContextHashModel)appModel).getServlet();
        TemplateModel requestModel = this.environment.getGlobalVariable("__FreeMarkerServlet.Request__");
        if (!(requestModel instanceof HttpRequestHashModel)) {
            requestModel = this.environment.getGlobalVariable("Request");
        }
        if (!(requestModel instanceof HttpRequestHashModel)) {
            throw new TemplateModelException("Could not find an instance of " + HttpRequestHashModel.class.getName() + " in the data model under either the name " + "__FreeMarkerServlet.Request__" + " or " + "Request");
        }
        HttpRequestHashModel reqHash = (HttpRequestHashModel)requestModel;
        this.request = reqHash.getRequest();
        this.session = this.request.getSession(false);
        this.response = reqHash.getResponse();
        this.wrapper = reqHash.getObjectWrapper();
        this.unwrapper = this.wrapper instanceof ObjectWrapperAndUnwrapper ? (ObjectWrapperAndUnwrapper)this.wrapper : null;
        this.setAttribute("jakarta.servlet.jsp.jspRequest", this.request);
        this.setAttribute("jakarta.servlet.jsp.jspResponse", this.response);
        if (this.session != null) {
            this.setAttribute("jakarta.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("jakarta.servlet.jsp.jspPage", this.servlet);
        this.setAttribute("jakarta.servlet.jsp.jspConfig", this.servlet.getServletConfig());
        this.setAttribute("jakarta.servlet.jsp.jspPageContext", this);
        this.setAttribute("jakarta.servlet.jsp.jspApplication", this.servlet.getServletContext());
    }

    ObjectWrapper getObjectWrapper() {
        return this.wrapper;
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) {
        throw new UnsupportedOperationException();
    }

    public void release() {
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 1);
    }

    public void setAttribute(String name, Object value, int scope) {
        switch (scope) {
            case 1: {
                try {
                    this.environment.setGlobalVariable(name, this.wrapper.wrap(value));
                    break;
                }
                catch (TemplateModelException e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
            case 2: {
                this.getRequest().setAttribute(name, value);
                break;
            }
            case 3: {
                this.getSession(true).setAttribute(name, value);
                break;
            }
            case 4: {
                this.getServletContext().setAttribute(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope " + scope);
            }
        }
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 1);
    }

    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                try {
                    TemplateModel tm = this.environment.getGlobalNamespace().get(name);
                    if (this.incompatibleImprovements >= _VersionInts.V_2_3_22 && this.unwrapper != null) {
                        return this.unwrapper.unwrap(tm);
                    }
                    if (tm instanceof AdapterTemplateModel) {
                        return ((AdapterTemplateModel)tm).getAdaptedObject(Object.class);
                    }
                    if (tm instanceof WrapperTemplateModel) {
                        return ((WrapperTemplateModel)tm).getWrappedObject();
                    }
                    if (tm instanceof TemplateScalarModel) {
                        return ((TemplateScalarModel)tm).getAsString();
                    }
                    if (tm instanceof TemplateNumberModel) {
                        return ((TemplateNumberModel)tm).getAsNumber();
                    }
                    if (tm instanceof TemplateBooleanModel) {
                        return ((TemplateBooleanModel)tm).getAsBoolean();
                    }
                    if (this.incompatibleImprovements >= _VersionInts.V_2_3_22 && tm instanceof TemplateDateModel) {
                        return ((TemplateDateModel)tm).getAsDate();
                    }
                    return tm;
                }
                catch (TemplateModelException e) {
                    throw new UndeclaredThrowableException("Failed to unwrapp FTL global variable", e);
                }
            }
            case 2: {
                return this.getRequest().getAttribute(name);
            }
            case 3: {
                HttpSession session = this.getSession(false);
                if (session == null) {
                    return null;
                }
                return session.getAttribute(name);
            }
            case 4: {
                return this.getServletContext().getAttribute(name);
            }
        }
        throw new IllegalArgumentException("Invalid scope " + scope);
    }

    public Object findAttribute(String name) {
        Object retval = this.getAttribute(name, 1);
        if (retval != null) {
            return retval;
        }
        retval = this.getAttribute(name, 2);
        if (retval != null) {
            return retval;
        }
        retval = this.getAttribute(name, 3);
        if (retval != null) {
            return retval;
        }
        return this.getAttribute(name, 4);
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, 1);
        this.removeAttribute(name, 2);
        this.removeAttribute(name, 3);
        this.removeAttribute(name, 4);
    }

    public void removeAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                this.environment.getGlobalNamespace().remove(name);
                break;
            }
            case 2: {
                this.getRequest().removeAttribute(name);
                break;
            }
            case 3: {
                HttpSession session = this.getSession(false);
                if (session == null) break;
                session.removeAttribute(name);
                break;
            }
            case 4: {
                this.getServletContext().removeAttribute(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope: " + scope);
            }
        }
    }

    public int getAttributesScope(String name) {
        if (this.getAttribute(name, 1) != null) {
            return 1;
        }
        if (this.getAttribute(name, 2) != null) {
            return 2;
        }
        if (this.getAttribute(name, 3) != null) {
            return 3;
        }
        if (this.getAttribute(name, 4) != null) {
            return 4;
        }
        return 0;
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                try {
                    return new TemplateHashModelExEnumeration(this.environment.getGlobalNamespace());
                }
                catch (TemplateModelException e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
            case 2: {
                return this.getRequest().getAttributeNames();
            }
            case 3: {
                HttpSession session = this.getSession(false);
                if (session != null) {
                    return session.getAttributeNames();
                }
                return Collections.enumeration(Collections.EMPTY_SET);
            }
            case 4: {
                return this.getServletContext().getAttributeNames();
            }
        }
        throw new IllegalArgumentException("Invalid scope " + scope);
    }

    public JspWriter getOut() {
        return this.jspOut;
    }

    private HttpSession getSession(boolean create) {
        if (this.session == null) {
            this.session = this.request.getSession(create);
            if (this.session != null) {
                this.setAttribute("jakarta.servlet.jsp.jspSession", this.session);
            }
        }
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(false);
    }

    public Object getPage() {
        return this.servlet;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        throw new UnsupportedOperationException();
    }

    public ServletConfig getServletConfig() {
        return this.servlet.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.servlet.getServletContext();
    }

    public void forward(String url) throws ServletException, IOException {
        this.request.getRequestDispatcher(url).forward((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public void include(String url) throws ServletException, IOException {
        this.jspOut.flush();
        this.request.getRequestDispatcher(url).include((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public void include(String url, boolean flush) throws ServletException, IOException {
        if (flush) {
            this.jspOut.flush();
        }
        final PrintWriter pw = new PrintWriter((Writer)this.jspOut);
        this.request.getRequestDispatcher(url).include((ServletRequest)this.request, (ServletResponse)new HttpServletResponseWrapper(this.response){

            public PrintWriter getWriter() {
                return pw;
            }

            public ServletOutputStream getOutputStream() {
                throw new UnsupportedOperationException("JSP-included resource must use getWriter()");
            }
        });
        pw.flush();
    }

    public void handlePageException(Exception e) {
        throw new UnsupportedOperationException();
    }

    public void handlePageException(Throwable e) {
        throw new UnsupportedOperationException();
    }

    public BodyContent pushBody() {
        return (BodyContent)this.pushWriter((JspWriter)new TagTransformModel.BodyContentImpl(this.getOut(), true));
    }

    public JspWriter pushBody(Writer w) {
        return this.pushWriter(new JspWriterAdapter(w));
    }

    public JspWriter popBody() {
        this.popWriter();
        return (JspWriter)this.getAttribute("jakarta.servlet.jsp.jspOut");
    }

    Object peekTopTag(Class tagClass) {
        ListIterator iter = this.tags.listIterator(this.tags.size());
        while (iter.hasPrevious()) {
            Object tag = iter.previous();
            if (!tagClass.isInstance(tag)) continue;
            return tag;
        }
        return null;
    }

    void popTopTag() {
        this.tags.remove(this.tags.size() - 1);
    }

    void popWriter() {
        this.jspOut = (JspWriter)this.outs.remove(this.outs.size() - 1);
        this.setAttribute("jakarta.servlet.jsp.jspOut", this.jspOut);
    }

    void pushTopTag(Object tag) {
        this.tags.add(tag);
    }

    JspWriter pushWriter(JspWriter out) {
        this.outs.add(this.jspOut);
        this.jspOut = out;
        this.setAttribute("jakarta.servlet.jsp.jspOut", this.jspOut);
        return out;
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        try {
            Class<?> type = ((ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            })).loadClass("org.apache.commons.el.ExpressionEvaluatorImpl");
            return (ExpressionEvaluator)type.newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("In order for the getExpressionEvaluator() method to work, you must have downloaded the apache commons-el jar and made it available in the classpath.");
        }
    }

    public VariableResolver getVariableResolver() {
        final FreeMarkerPageContext ctx = this;
        return new VariableResolver(){

            public Object resolveVariable(String name) throws ELException {
                return ctx.findAttribute(name);
            }
        };
    }

    public ELContext getELContext() {
        if (this.elContext == null) {
            JspApplicationContext jspctx = JspFactory.getDefaultFactory().getJspApplicationContext(this.getServletContext());
            if (jspctx instanceof FreeMarkerJspApplicationContext) {
                this.elContext = ((FreeMarkerJspApplicationContext)jspctx).createNewELContext(this);
                this.elContext.putContext(JspContext.class, (Object)this);
            } else {
                throw new UnsupportedOperationException("Can not create an ELContext using a foreign JspApplicationContext (of class " + ClassUtil.getShortClassNameOfObject(jspctx) + ").\nHint: The cause of this is often that you are trying to use JSTL tags/functions in FTL. In that case, know that that's not really suppored, and you are supposed to use FTL constrcuts instead, like #list instead of JSTL's forEach, etc.");
            }
        }
        return this.elContext;
    }

    static {
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)new FreeMarkerJspFactory());
        }
        LOG.debug("Using JspFactory implementation class " + JspFactory.getDefaultFactory().getClass().getName());
    }

    private static class TemplateHashModelExEnumeration
    implements Enumeration {
        private final TemplateModelIterator it;

        private TemplateHashModelExEnumeration(TemplateHashModelEx hashEx) throws TemplateModelException {
            this.it = hashEx.keys().iterator();
        }

        @Override
        public boolean hasMoreElements() {
            try {
                return this.it.hasNext();
            }
            catch (TemplateModelException tme) {
                throw new UndeclaredThrowableException(tme);
            }
        }

        public Object nextElement() {
            try {
                return ((TemplateScalarModel)this.it.next()).getAsString();
            }
            catch (TemplateModelException tme) {
                throw new UndeclaredThrowableException(tme);
            }
        }
    }
}

