/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.vault;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Capability;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.vault.VaultLogLevel;

public class VaultContainer<SELF extends VaultContainer<SELF>>
extends GenericContainer<SELF> {
    private static final DockerImageName DEFAULT_OLD_IMAGE_NAME = DockerImageName.parse((String)"vault");
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"hashicorp/vault");
    private static final String DEFAULT_TAG = "1.1.3";
    private static final int VAULT_PORT = 8200;
    private Map<String, List<String>> secretsMap = new HashMap<String, List<String>>();
    private List<String> initCommands = new ArrayList<String>();
    private int port = 8200;

    @Deprecated
    public VaultContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public VaultContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public VaultContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_OLD_IMAGE_NAME, DEFAULT_IMAGE_NAME});
        this.setWaitStrategy((WaitStrategy)Wait.forHttp((String)"/v1/sys/health").forStatusCode(200));
        this.withCreateContainerCmdModifier(cmd -> cmd.withCapAdd(new Capability[]{Capability.IPC_LOCK}));
        this.withEnv("VAULT_ADDR", "http://0.0.0.0:" + this.port);
        this.withExposedPorts(new Integer[]{this.port});
    }

    public String getHttpHostAddress() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(this.port));
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.addSecrets();
        this.runInitCommands();
    }

    private void addSecrets() {
        if (!this.secretsMap.isEmpty()) {
            try {
                this.execInContainer(this.buildExecCommand(this.secretsMap)).getStdout().contains("Success");
            }
            catch (IOException | InterruptedException e) {
                this.logger().error("Failed to add these secrets {} into Vault via exec command. Exception message: {}", this.secretsMap, (Object)e.getMessage());
            }
        }
    }

    private String[] buildExecCommand(Map<String, List<String>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        map.forEach((path, secrets) -> {
            stringBuilder.append(" && vault kv put " + path);
            secrets.forEach(item -> stringBuilder.append(" " + item));
        });
        return new String[]{"/bin/sh", "-c", stringBuilder.toString().substring(4)};
    }

    private void runInitCommands() {
        if (!this.initCommands.isEmpty()) {
            String commands = this.initCommands.stream().map(command -> "vault " + command).collect(Collectors.joining(" && "));
            try {
                Container.ExecResult execResult = this.execInContainer(new String[]{"/bin/sh", "-c", commands});
                if (execResult.getExitCode() != 0) {
                    this.logger().error("Failed to execute these init commands {}. Exit code {}. Stdout {}. Stderr {}", new Object[]{this.initCommands, execResult.getExitCode(), execResult.getStdout(), execResult.getStderr()});
                }
            }
            catch (IOException | InterruptedException e) {
                this.logger().error("Failed to execute these init commands {}. Exception message: {}", this.initCommands, (Object)e.getMessage());
            }
        }
    }

    public SELF withVaultToken(String token) {
        this.withEnv("VAULT_DEV_ROOT_TOKEN_ID", token);
        this.withEnv("VAULT_TOKEN", token);
        return (SELF)((Object)((VaultContainer)this.self()));
    }

    @Deprecated
    public SELF withVaultPort(int port) {
        this.port = port;
        return (SELF)((Object)((VaultContainer)this.self()));
    }

    @Deprecated
    public SELF withLogLevel(VaultLogLevel level) {
        return (SELF)((Object)((VaultContainer)this.withEnv("VAULT_LOG_LEVEL", level.config)));
    }

    @Deprecated
    public SELF withSecretInVault(String path, String firstSecret, String ... remainingSecrets) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(firstSecret);
        for (String secret : remainingSecrets) {
            list.add(secret);
        }
        if (this.secretsMap.containsKey(path)) {
            list.addAll(list);
        }
        this.secretsMap.putIfAbsent(path, list);
        return (SELF)((Object)((VaultContainer)this.self()));
    }

    public SELF withInitCommand(String ... commands) {
        this.initCommands.addAll(Arrays.asList(commands));
        return (SELF)((Object)((VaultContainer)this.self()));
    }
}

