/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx;

import com.google.common.base.Predicate;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javafx.scene.Node;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.hamcrest.Matcher;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.loadui.testfx.exceptions.NoNodesFoundException;
import org.loadui.testfx.exceptions.NoNodesVisibleException;
import org.loadui.testfx.exceptions.NodeQueryException;
import org.testfx.api.FxRobot;
import org.testfx.api.FxService;
import org.testfx.service.finder.NodeFinder;
import org.testfx.service.finder.NodeFinderException;
import org.testfx.service.finder.WindowFinder;
import org.testfx.service.support.CaptureSupport;
import org.testfx.service.support.WaitUntilSupport;

public class FxTest
extends FxRobot {
    private static final WindowFinder windowFinder = FxService.serviceContext().getWindowFinder();
    private static final NodeFinder nodeFinder = FxService.serviceContext().getNodeFinder();
    private static final WaitUntilSupport waitUntilSupport = FxService.serviceContext().getWaitUntilSupport();
    private static final CaptureSupport captureSupport = FxService.serviceContext().getCaptureSupport();

    public static <T extends Window> T targetWindow(T window) {
        windowFinder.target(window);
        return window;
    }

    public static List<Window> getWindows() {
        return windowFinder.listWindows();
    }

    public static Window getWindowByIndex(int windowIndex) {
        return windowFinder.window(windowIndex);
    }

    public static Stage findStageByTitle(String stageTitleRegex) {
        return (Stage)windowFinder.window(stageTitleRegex);
    }

    public static <T extends Node> T find(String query) {
        try {
            return (T)nodeFinder.nodes(query).queryFirst();
        }
        catch (NodeFinderException exception) {
            throw FxTest.buildNodeQueryException(exception);
        }
    }

    public static <T extends Node> Set<T> findAll(String query) {
        try {
            return nodeFinder.nodes(query).queryAll();
        }
        catch (NodeFinderException exception) {
            throw FxTest.buildNodeQueryException(exception);
        }
    }

    public static <T extends Node> T find(Predicate<T> predicate) {
        try {
            return (T)nodeFinder.nodes(predicate).queryFirst();
        }
        catch (NodeFinderException exception) {
            throw FxTest.buildNodeQueryException(exception);
        }
    }

    public static <T extends Node> T find(Matcher<Object> matcher) {
        try {
            return (T)nodeFinder.nodes(matcher).queryFirst();
        }
        catch (NodeFinderException exception) {
            throw FxTest.buildNodeQueryException(exception);
        }
    }

    public static <T extends Node> T find(String query, Node parent) {
        try {
            return (T)nodeFinder.nodesFrom(new Node[]{parent}).lookup(query).queryFirst();
        }
        catch (NodeFinderException exception) {
            throw FxTest.buildNodeQueryException(exception);
        }
    }

    public static <T extends Node> Set<T> findAll(Predicate<T> predicate, Node parent) {
        try {
            return nodeFinder.nodesFrom(new Node[]{parent}).lookup(predicate).queryAll();
        }
        catch (NodeFinderException exception) {
            throw FxTest.buildNodeQueryException(exception);
        }
    }

    public static <T extends Node> Set<T> findAll(Matcher<Object> matcher, Node parent) {
        try {
            return nodeFinder.nodesFrom(new Node[]{parent}).lookup(matcher).queryAll();
        }
        catch (NodeFinderException exception) {
            throw FxTest.buildNodeQueryException(exception);
        }
    }

    public static boolean exists(String nodeQuery) {
        try {
            return FxTest.find(nodeQuery) != null;
        }
        catch (NodeFinderException exception) {
            throw FxTest.buildNodeQueryException(exception);
        }
    }

    public static Callable<Integer> numberOf(String nodeQuery) {
        return () -> FxTest.findAll(nodeQuery).size();
    }

    public static <T extends Node> void waitUntil(T node, Predicate<T> condition) {
        FxTest.waitUntil(node, condition, 15);
    }

    public static <T extends Node> void waitUntil(T node, Predicate<T> condition, int timeoutInSeconds) {
        waitUntilSupport.waitUntil(node, condition, timeoutInSeconds);
    }

    public static void waitUntil(Node node, Matcher<Object> condition) {
        FxTest.waitUntil(node, condition, 15);
    }

    public static void waitUntil(Node node, Matcher<Object> condition, int timeoutInSeconds) {
        waitUntilSupport.waitUntil(node, condition, timeoutInSeconds);
    }

    public static <T> void waitUntil(T value, Matcher<? super T> condition) {
        FxTest.waitUntil(value, condition, 15);
    }

    public static <T> void waitUntil(T value, Matcher<? super T> condition, int timeoutInSeconds) {
        waitUntilSupport.waitUntil(value, condition, timeoutInSeconds);
    }

    public static <T> void waitUntil(Callable<T> callable, Matcher<? super T> condition) {
        FxTest.waitUntil(callable, condition, 15);
    }

    public static <T> void waitUntil(Callable<T> callable, Matcher<? super T> condition, int timeoutInSeconds) {
        waitUntilSupport.waitUntil(callable, condition, timeoutInSeconds);
    }

    public static File captureScreenshot() {
        File captureFile = new File("screenshot" + new Date().getTime() + ".png");
        captureSupport.capturePrimaryScreenToFile(captureFile);
        return captureFile;
    }

    private static NodeQueryException buildNodeQueryException(NodeFinderException exception) {
        switch (exception.getErrorType()) {
            case NO_NODES_FOUND: {
                throw new NoNodesFoundException(exception.getMessage());
            }
            case NO_VISIBLE_NODES_FOUND: {
                throw new NoNodesVisibleException(exception.getMessage());
            }
        }
        throw new AssertionError((Object)"Unhandled NodeFinderException.");
    }

    @BeforeClass
    public static void internalSetupSpec() {
        Assume.assumeFalse((String)"Cannot run JavaFX in headless environment", (boolean)GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance());
    }
}

