/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx.controls.impl;

import javafx.scene.Node;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.loadui.testfx.GuiTest;
import org.loadui.testfx.exceptions.NoNodesFoundException;

public class EnabledMatcher
extends TypeSafeMatcher<Object> {
    private boolean shouldBeDisabled;

    private EnabledMatcher(boolean shouldBeEnabled) {
        this.shouldBeDisabled = shouldBeEnabled;
    }

    @Factory
    public static Matcher<Object> enabled() {
        return new EnabledMatcher(false);
    }

    @Factory
    public static Matcher<Object> disabled() {
        return new EnabledMatcher(true);
    }

    public void describeTo(Description desc) {
        desc.appendText("Node should be " + (this.shouldBeDisabled ? "Dis" : "En") + "abled");
    }

    public boolean matchesSafely(Object target) {
        if (target instanceof String) {
            try {
                Object node = GuiTest.find((String)target);
                return node.isDisabled() == this.shouldBeDisabled;
            }
            catch (NoNodesFoundException e) {
                return false;
            }
        }
        if (target instanceof Node) {
            return ((Node)target).isDisabled() == this.shouldBeDisabled;
        }
        return false;
    }
}

