/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx;

import com.google.common.base.Predicate;
import javafx.scene.Node;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.loadui.testfx.GuiTest;

public class Assertions {
    public static void assertNodeExists(Matcher<?> matcher) {
        GuiTest.find(matcher);
    }

    public static void assertNodeExists(String query) {
        GuiTest.find(query);
    }

    public static <T> void verifyThat(T value, Matcher<? super T> matcher) {
        Assertions.verifyThat("", value, matcher);
    }

    public static <T> void verifyThat(String reason, T value, Matcher<? super T> matcher) {
        try {
            MatcherAssert.assertThat((String)reason, value, matcher);
        }
        catch (AssertionError e) {
            throw new AssertionError(((Throwable)((Object)e)).getMessage() + " Screenshot saved as " + GuiTest.captureScreenshot().getAbsolutePath(), (Throwable)((Object)e));
        }
    }

    public static <T extends Node> void verifyThat(String query, Predicate<T> predicate) {
        Object node = GuiTest.find(query);
        if (!predicate.apply(node)) {
            throw new AssertionError((Object)("Predicate failed for query '" + query + "'. Screenshot saved as " + GuiTest.captureScreenshot().getAbsolutePath()));
        }
    }

    public static <T extends Node> void verifyThat(T node, Predicate<T> predicate) {
        if (!predicate.apply(node)) {
            throw new AssertionError((Object)("Predicate failed for '" + node + "'. Screenshot saved as " + GuiTest.captureScreenshot().getAbsolutePath()));
        }
    }
}

