/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx.controls;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.loadui.testfx.GuiTest;
import org.loadui.testfx.exceptions.NoNodesFoundException;

public class TableViews {
    public static int numberOfRowsIn(TableView<?> table) {
        return table.getItems().size();
    }

    public static int numberOfRowsIn(String tableQuery) {
        TableView table = (TableView)GuiTest.find(tableQuery);
        return table.getItems().size();
    }

    @Factory
    public static <S> Matcher<S> containsCell(Object cellValue) {
        return new TableContainsMatcher(cellValue);
    }

    static List<TableColumn> flatten(TableColumn col) {
        if (col.getColumns().size() == 0) {
            return Arrays.asList(col);
        }
        ArrayList<TableColumn> l = new ArrayList<TableColumn>();
        col.getColumns().forEach(xa -> l.addAll(TableViews.flatten((TableColumn)xa)));
        return l;
    }

    static List<TableColumn> getFlattenedColumns(TableView<?> table) {
        ArrayList<TableColumn> l = new ArrayList<TableColumn>();
        table.getColumns().forEach(c -> l.addAll(TableViews.flatten(c)));
        return l;
    }

    static boolean containsCell(TableView<?> table, Predicate<String> cellPredicate) {
        for (TableColumn column : TableViews.getFlattenedColumns(table)) {
            for (int i = 0; i < table.getItems().size(); ++i) {
                Object cellData = column.getCellData(i);
                if (!cellPredicate.apply((Object)cellData.toString())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean containsCell(TableView<?> table, Object cellValue) {
        for (TableColumn column : TableViews.getFlattenedColumns(table)) {
            for (int i = 0; i < table.getItems().size(); ++i) {
                Object cellData = column.getCellData(i);
                if (!cellValue.equals(cellData) && !cellValue.equals(cellData.toString())) continue;
                return true;
            }
        }
        return false;
    }

    static TableView<?> getTableView(String tableSelector) {
        Object node = GuiTest.find(tableSelector);
        if (!(node instanceof TableView)) {
            throw new NoNodesFoundException(tableSelector + " selected " + node + " which is not a TableView!");
        }
        return (TableView)node;
    }

    protected static Object cellValue(String tableSelector, int row, int column) {
        return ((TableColumn)TableViews.getTableView(tableSelector).getColumns().get(column)).getCellData(row);
    }

    protected static TableRow<?> row(String tableSelector, int row) {
        TableView<?> tableView = TableViews.getTableView(tableSelector);
        ObservableList current = tableView.getChildrenUnmodifiable();
        while (current.size() == 1) {
            current = ((Parent)current.get(0)).getChildrenUnmodifiable();
        }
        current = ((Parent)current.get(1)).getChildrenUnmodifiable();
        while (!(current.get(0) instanceof TableRow)) {
            current = ((Parent)current.get(0)).getChildrenUnmodifiable();
        }
        Node node = (Node)current.get(row);
        if (node instanceof TableRow) {
            return (TableRow)node;
        }
        throw new RuntimeException("Expected Group with only TableRows as children");
    }

    protected static TableCell<?, ?> cell(String tableSelector, int row, int column) {
        ObservableList current = TableViews.row(tableSelector, row).getChildrenUnmodifiable();
        while (current.size() == 1 && !(current.get(0) instanceof TableCell)) {
            current = ((Parent)current.get(0)).getChildrenUnmodifiable();
        }
        Node node = (Node)current.get(column);
        if (node instanceof TableCell) {
            return (TableCell)node;
        }
        throw new RuntimeException("Expected TableRowSkin with only TableCells as children");
    }

    private static class TableContainsMatcher
    extends BaseMatcher {
        private Object valueToMatch;

        public TableContainsMatcher(Object valueToMatch) {
            this.valueToMatch = valueToMatch;
        }

        public boolean matches(Object o) {
            if (o instanceof String) {
                String query = (String)o;
                if (this.valueToMatch instanceof Predicate) {
                    return TableViews.containsCell(TableViews.getTableView(query), (Predicate<String>)((Predicate)this.valueToMatch));
                }
                return TableViews.containsCell(TableViews.getTableView(query), this.valueToMatch);
            }
            if (o instanceof TableView) {
                TableView tableView = (TableView)o;
                if (this.valueToMatch instanceof Predicate) {
                    return TableViews.containsCell(tableView, (Predicate<String>)((Predicate)this.valueToMatch));
                }
                return TableViews.containsCell(tableView, this.valueToMatch);
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("The table does not contain a cell with value '" + this.valueToMatch + "'");
        }
    }
}

