/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.hamcrest.Matcher;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.loadui.testfx.exceptions.NoNodesFoundException;
import org.loadui.testfx.exceptions.NoNodesVisibleException;
import org.loadui.testfx.exceptions.NodeQueryException;
import org.testfx.api.FxRobot;
import org.testfx.api.FxService;
import org.testfx.api.FxToolkit;
import org.testfx.service.finder.NodeFinder;
import org.testfx.service.finder.NodeFinderException;
import org.testfx.service.finder.WindowFinder;
import org.testfx.service.support.CaptureSupport;
import org.testfx.service.support.WaitUntilSupport;
import org.testfx.util.WaitForAsyncUtils;

public abstract class GuiTest
extends FxRobot {
    private static final WindowFinder WINDOW_FINDER = FxService.serviceContext().getWindowFinder();
    private static final NodeFinder NODE_FINDER = FxService.serviceContext().getNodeFinder();
    private static final WaitUntilSupport WAIT_UNTIL_SUPPORT = FxService.serviceContext().getWaitUntilSupport();
    private static final CaptureSupport CAPTURE_SUPPORT = FxService.serviceContext().getCaptureSupport();

    public static <T extends Window> T _targetWindow(T window) {
        WINDOW_FINDER.targetWindow(window);
        return window;
    }

    public static List<Window> getWindows() {
        return WINDOW_FINDER.listTargetWindows();
    }

    public static Window getWindowByIndex(int windowIndex) {
        return WINDOW_FINDER.window(windowIndex);
    }

    public static Stage findStageByTitle(String stageTitleRegex) {
        return (Stage)WINDOW_FINDER.window(stageTitleRegex);
    }

    public static <T extends Node> T find(String query) {
        try {
            return (T)NODE_FINDER.lookup(query).query();
        }
        catch (NodeFinderException exception) {
            throw GuiTest.buildNodeQueryException(exception);
        }
    }

    public static <T extends Node> Set<T> findAll(String query) {
        try {
            return NODE_FINDER.lookup(query).queryAll();
        }
        catch (NodeFinderException exception) {
            throw GuiTest.buildNodeQueryException(exception);
        }
    }

    public static <T extends Node> T find(Predicate<T> predicate) {
        try {
            return (T)NODE_FINDER.lookup(predicate).query();
        }
        catch (NodeFinderException exception) {
            throw GuiTest.buildNodeQueryException(exception);
        }
    }

    public static <T extends Node> T find(Matcher<Object> matcher) {
        try {
            return (T)NODE_FINDER.lookup(matcher).query();
        }
        catch (NodeFinderException exception) {
            throw GuiTest.buildNodeQueryException(exception);
        }
    }

    public static <T extends Node> T find(String query, Node parent) {
        try {
            return (T)NODE_FINDER.from(new Node[]{parent}).lookup(query).query();
        }
        catch (NodeFinderException exception) {
            throw GuiTest.buildNodeQueryException(exception);
        }
    }

    public static <T extends Node> Set<T> findAll(Predicate<T> predicate, Node parent) {
        try {
            return NODE_FINDER.from(new Node[]{parent}).lookup(predicate).queryAll();
        }
        catch (NodeFinderException exception) {
            throw GuiTest.buildNodeQueryException(exception);
        }
    }

    public static <T extends Node> Set<T> findAll(Matcher<Object> matcher, Node parent) {
        try {
            return NODE_FINDER.from(new Node[]{parent}).lookup(matcher).queryAll();
        }
        catch (NodeFinderException exception) {
            throw GuiTest.buildNodeQueryException(exception);
        }
    }

    public static boolean exists(String nodeQuery) {
        try {
            return GuiTest.find(nodeQuery) != null;
        }
        catch (NodeFinderException exception) {
            throw GuiTest.buildNodeQueryException(exception);
        }
    }

    public static Callable<Integer> numberOf(String nodeQuery) {
        return () -> GuiTest.findAll(nodeQuery).size();
    }

    public static <T extends Node> void waitUntil(T node, Predicate<T> condition) {
        GuiTest.waitUntil(node, condition, 15);
    }

    public static <T extends Node> void waitUntil(T node, Predicate<T> condition, int timeoutInSeconds) {
        WAIT_UNTIL_SUPPORT.waitUntil(node, condition, timeoutInSeconds);
    }

    public static void waitUntil(Node node, Matcher<Object> condition) {
        GuiTest.waitUntil(node, condition, 15);
    }

    public static void waitUntil(Node node, Matcher<Object> condition, int timeoutInSeconds) {
        WAIT_UNTIL_SUPPORT.waitUntil(node, condition, timeoutInSeconds);
    }

    public static <T> void waitUntil(T value, Matcher<? super T> condition) {
        GuiTest.waitUntil(value, condition, 15);
    }

    public static <T> void waitUntil(T value, Matcher<? super T> condition, int timeoutInSeconds) {
        WAIT_UNTIL_SUPPORT.waitUntil(value, condition, timeoutInSeconds);
    }

    public static <T> void waitUntil(Callable<T> callable, Matcher<? super T> condition) {
        GuiTest.waitUntil(callable, condition, 15);
    }

    public static <T> void waitUntil(Callable<T> callable, Matcher<? super T> condition, int timeoutInSeconds) {
        WAIT_UNTIL_SUPPORT.waitUntil(callable, condition, timeoutInSeconds);
    }

    public static File captureScreenshot() {
        Path captureFile = Paths.get("screenshot" + new Date().getTime() + ".png", new String[0]);
        Image captureImage = CAPTURE_SUPPORT.captureRegion(Screen.getPrimary().getBounds());
        CAPTURE_SUPPORT.saveImage(captureImage, captureFile);
        return captureFile.toFile();
    }

    private static NodeQueryException buildNodeQueryException(NodeFinderException exception) {
        switch (exception.getErrorType()) {
            case NO_NODES_FOUND: {
                throw new NoNodesFoundException(exception.getMessage());
            }
            case NO_VISIBLE_NODES_FOUND: {
                throw new NoNodesVisibleException(exception.getMessage());
            }
        }
        throw new AssertionError((Object)"Unhandled NodeFinderException.");
    }

    @BeforeClass
    public static void internalSetupSpec() {
        Assume.assumeFalse((String)"Cannot run JavaFX in headless environment", (boolean)GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance());
    }

    @Before
    public void internalSetup() throws Exception {
        this.targetWindow((Window)FxToolkit.registerPrimaryStage());
        FxToolkit.setupSceneRoot(this::getRootNode);
        WaitForAsyncUtils.waitForFxEvents();
        FxToolkit.setupStage(stage -> {
            stage.show();
            stage.toBack();
            stage.toFront();
        });
        WaitForAsyncUtils.waitForFxEvents();
    }

    protected abstract Parent getRootNode();
}

