/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.testfx.util.WaitForAsyncUtils;

public class FXTestUtils {
    private FXTestUtils() {
        throw new UnsupportedOperationException();
    }

    public static void awaitCondition(Callable<Boolean> condition) {
        FXTestUtils.awaitCondition(condition, 5);
    }

    public static void awaitCondition(Callable<Boolean> condition, int timeoutInSeconds) {
        try {
            WaitForAsyncUtils.waitFor((long)timeoutInSeconds, (TimeUnit)TimeUnit.SECONDS, condition);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void awaitEvents() {
        WaitForAsyncUtils.waitForFxEvents();
    }

    public static void invokeAndWait(Callable<?> task, int timeoutInSeconds) throws Exception {
        Future future = WaitForAsyncUtils.asyncFx(task);
        WaitForAsyncUtils.waitFor((long)timeoutInSeconds, (TimeUnit)TimeUnit.SECONDS, (Future)future);
        WaitForAsyncUtils.waitForFxEvents();
    }

    public static void invokeAndWait(Runnable task, int timeoutInSeconds) throws Exception {
        FXTestUtils.invokeAndWait(Executors.callable(task), timeoutInSeconds);
    }
}

