/*
 * Decompiled with CFR 0.152.
 */
package org.testinfected.hamcrest.core;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsBlankString
extends TypeSafeDiagnosingMatcher<String> {
    protected boolean matchesSafely(String actual, Description mismatchDescription) {
        if (!this.isBlank(actual)) {
            mismatchDescription.appendText(actual);
            return false;
        }
        return true;
    }

    private boolean isBlank(String actual) {
        if (actual == null) {
            return true;
        }
        for (int i = 0; i < actual.length(); ++i) {
            char c = actual.charAt(i);
            if (Character.isSpaceChar(c) || Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("a blank string");
    }

    @Factory
    public static Matcher<String> isBlank() {
        return new IsBlankString();
    }
}

