/*
 * Decompiled with CFR 0.152.
 */
package org.testinfected.hamcrest.spring;

import org.hamcrest.Factory;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.springframework.ui.Model;

public class HasAttribute<T>
extends FeatureMatcher<Model, T> {
    private final String key;

    public HasAttribute(String key, Matcher<? super T> valueMatcher) {
        super(valueMatcher, "with \"" + key + "\"", "\"" + key + "\"");
        this.key = key;
    }

    protected T featureValueOf(Model actual) {
        return (T)actual.asMap().get(this.key);
    }

    @Factory
    public static <T> Matcher<Model> hasAttribute(String key, T value) {
        return HasAttribute.hasAttributeValue(key, Matchers.equalTo(value));
    }

    @Factory
    public static <T> Matcher<Model> hasAttributeValue(String key, Matcher<? super T> valueMatcher) {
        return new HasAttribute<T>(key, valueMatcher);
    }

    public static <T> Matcher<Model> containsAttribute(String key) {
        return new HasAttribute<T>(key, Matchers.not((Matcher)Matchers.nullValue()));
    }
}

