/*
 * Decompiled with CFR 0.152.
 */
package org.testinfected.hamcrest.dom;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.testinfected.hamcrest.dom.HasAttribute;
import org.testinfected.hamcrest.dom.HasAttributeValue;
import org.testinfected.hamcrest.dom.HasChildren;
import org.testinfected.hamcrest.dom.HasContentText;
import org.testinfected.hamcrest.dom.HasNoSelector;
import org.testinfected.hamcrest.dom.HasSelector;
import org.testinfected.hamcrest.dom.HasTag;
import org.testinfected.hamcrest.dom.HasUniqueSelector;
import org.w3c.dom.Element;

public class DomMatchers {
    private DomMatchers() {
    }

    public static Matcher<Element> hasSelector(String selector, Matcher<? super Element> ... subjectsMatchers) {
        return HasSelector.hasSelector(selector, subjectsMatchers);
    }

    public static Matcher<Element> hasSelector(String selector, Matcher<Iterable<Element>> subjectsMatcher) {
        return HasSelector.hasSelector(selector, subjectsMatcher);
    }

    public static Matcher<Iterable<Element>> hasSize(int size) {
        return Matchers.iterableWithSize((int)size);
    }

    public static Matcher<Element> hasUniqueSelector(String selector) {
        return HasUniqueSelector.hasUniqueSelector(selector);
    }

    public static Matcher<Element> hasUniqueSelector(String selector, Matcher<? super Element> subjectMatcher) {
        return HasUniqueSelector.hasUniqueSelector(selector, subjectMatcher);
    }

    public static Matcher<Element> hasUniqueSelector(String selector, Matcher<? super Element> ... subjectMatchers) {
        return HasUniqueSelector.hasUniqueSelector(selector, subjectMatchers);
    }

    public static Matcher<Element> hasNoSelector(String selector) {
        return HasNoSelector.hasNoSelector(selector);
    }

    public static Matcher<Iterable<Element>> matches(Matcher<? super Element> ... elementsMatchers) {
        return DomMatchers.matches(Arrays.asList(elementsMatchers));
    }

    public static Matcher<Iterable<Element>> matches(List<Matcher<? super Element>> elementsMatcher) {
        return new IsIterableContainingInOrder(elementsMatcher);
    }

    public static Matcher<Iterable<Element>> matchesInAnyOrder(Matcher<? super Element> ... elementsMatchers) {
        return DomMatchers.matchesInAnyOrder(Arrays.asList(elementsMatchers));
    }

    public static Matcher<Iterable<Element>> matchesInAnyOrder(List<Matcher<? super Element>> elementsMatcher) {
        return new IsIterableContainingInAnyOrder(elementsMatcher);
    }

    public static Matcher<Iterable<Element>> includes(Matcher<? super Element> ... elementsMatchers) {
        return Matchers.hasItems(elementsMatchers);
    }

    public static Matcher<Element> hasTag(String tagName) {
        return HasTag.hasTag(tagName);
    }

    public static Matcher<Element> hasText(String contentText) {
        return HasContentText.hasContent(contentText);
    }

    public static Matcher<Element> hasText(Matcher<? super String> contentMatcher) {
        return HasContentText.hasContent(contentMatcher);
    }

    public static Matcher<Element> hasBlankText() {
        return HasContentText.hasBlankContent();
    }

    public static Matcher<Element> hasAttribute(String name) {
        return HasAttribute.hasAttribute(name);
    }

    public static Matcher<Element> hasAttribute(String name, String value) {
        return HasAttributeValue.hasAttribute(name, value);
    }

    public static Matcher<Element> hasAttribute(String name, Matcher<? super String> valueMatcher) {
        return HasAttributeValue.hasAttribute(name, valueMatcher);
    }

    public static Matcher<Element> hasName(String name) {
        return HasAttributeValue.hasName(name);
    }

    public static Matcher<Element> hasId(String id) {
        return HasAttributeValue.hasId(id);
    }

    public static Matcher<Element> hasClassName(String className) {
        return HasAttributeValue.hasClassName(className);
    }

    public static Matcher<Element> hasChildren(Matcher<? super Element> ... childrenMatchers) {
        return HasChildren.hasChildren(childrenMatchers);
    }

    public static Matcher<Element> hasChildren(Matcher<Iterable<Element>> childrenMatcher) {
        return HasChildren.hasChildren(childrenMatcher);
    }

    public static Matcher<Element> hasChild(Matcher<? super Element> childMatcher) {
        return HasChildren.hasChild(childMatcher);
    }

    public static Matcher<Element> anElement(Matcher<? super Element> ... elementMatchers) {
        return Matchers.allOf(elementMatchers);
    }
}

