/*
 * Decompiled with CFR 0.152.
 */
package org.testinfected.hamcrest.dom;

import com.google.common.collect.Iterables;
import com.threelevers.css.Selector;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.testinfected.hamcrest.dom.DomMatchers;
import org.w3c.dom.Element;

public class HasUniqueSelector
extends TypeSafeDiagnosingMatcher<Element> {
    private final String selector;
    private final Matcher<? super Element> subjectMatcher;

    public HasUniqueSelector(String selector, Matcher<? super Element> subjectMatcher) {
        this.selector = selector;
        this.subjectMatcher = subjectMatcher;
    }

    protected boolean matchesSafely(Element doc, Description mismatchDescription) {
        Iterable allElements = Selector.from((Element)doc).select(this.selector);
        if (!this.isSingleton(allElements)) {
            mismatchDescription.appendText(String.valueOf(Iterables.size((Iterable)allElements)));
            mismatchDescription.appendText(" selector(s) ");
            mismatchDescription.appendText("\"" + this.selector + "\"");
            return false;
        }
        Element element = (Element)Iterables.getOnlyElement((Iterable)allElements);
        boolean valueMatches = this.subjectMatcher.matches((Object)element);
        if (!valueMatches) {
            mismatchDescription.appendText(this.selector + " ");
            this.subjectMatcher.describeMismatch((Object)element, mismatchDescription);
        }
        return valueMatches;
    }

    private boolean isSingleton(Iterable<Element> elements) {
        return Iterables.size(elements) == 1;
    }

    public void describeTo(Description description) {
        description.appendText("has unique selector \"");
        description.appendText(this.selector);
        description.appendText("\" ");
        this.subjectMatcher.describeTo(description);
    }

    @Factory
    public static Matcher<Element> hasUniqueSelector(String selector) {
        return new HasUniqueSelector(selector, (Matcher<? super Element>)Matchers.anything());
    }

    @Factory
    public static Matcher<Element> hasUniqueSelector(String selector, Matcher<? super Element> ... subjectMatchers) {
        return HasUniqueSelector.hasUniqueSelector(selector, DomMatchers.anElement(subjectMatchers));
    }

    @Factory
    public static Matcher<Element> hasUniqueSelector(String selector, Matcher<? super Element> subjectMatcher) {
        return new HasUniqueSelector(selector, subjectMatcher);
    }
}

