/*
 * Decompiled with CFR 0.152.
 */
package org.testinfected.hamcrest.jpa;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;
import org.testinfected.hamcrest.jpa.PersistentFieldPredicate;
import org.testinfected.hamcrest.jpa.SamePersistentFieldsAs;

public class IsComponentEqual<T>
extends DiagnosingMatcher<T> {
    private final T component;

    public IsComponentEqual(T expectedComponent) {
        this.component = expectedComponent;
    }

    protected boolean matches(Object argument, Description mismatchDescription) {
        if (this.component == null && argument == null) {
            return true;
        }
        if (this.component == null) {
            Matcher<T> valueMatcher = this.allNullFields(argument);
            boolean match = valueMatcher.matches(argument);
            if (!match) {
                valueMatcher.describeMismatch(argument, mismatchDescription);
            }
            return match;
        }
        if (argument == null) {
            Matcher<T> valueMatcher = this.allNullFields(this.component);
            boolean match = valueMatcher.matches(this.component);
            if (!match) {
                mismatchDescription.appendText("is null");
            }
            return match;
        }
        SamePersistentFieldsAs<T> valueMatcher = new SamePersistentFieldsAs<T>(this.component);
        boolean match = valueMatcher.matches(argument);
        if (!match) {
            valueMatcher.describeMismatch(argument, mismatchDescription);
        }
        return match;
    }

    private Matcher<T> allNullFields(Object target) {
        ArrayList nullFields = new ArrayList();
        for (Field field : PersistentFieldPredicate.persistentFieldsOf(target)) {
            nullFields.add(new HasFieldWithValue(field.getName(), Matchers.nullValue()));
        }
        return Matchers.allOf(nullFields);
    }

    public void describeTo(Description description) {
        if (this.component == null) {
            description.appendText("null");
        } else {
            new SamePersistentFieldsAs<T>(this.component).describeTo(description);
        }
    }

    @Factory
    public static <T> Matcher<T> componentEqualTo(T component) {
        return new IsComponentEqual<T>(component);
    }
}

