/*
 * Decompiled with CFR 0.152.
 */
package org.testinfected.hamcrest.dom;

import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.testinfected.hamcrest.dom.Selector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HasSelector
extends TypeSafeDiagnosingMatcher<Element> {
    private final String selector;
    private final Matcher<Iterable<Element>> subjectsMatcher;

    public HasSelector(String selector) {
        this(selector, null);
    }

    public HasSelector(String selector, Matcher<Iterable<Element>> subjectsMatchers) {
        this.selector = selector;
        this.subjectsMatcher = subjectsMatchers;
    }

    protected boolean matchesSafely(Element element, Description mismatchDescription) {
        Set<Node> selected = Selector.from(element).selectAll(this.selector);
        if (selected.isEmpty()) {
            mismatchDescription.appendText("no selector ");
            mismatchDescription.appendText("\"" + this.selector + "\"");
            return false;
        }
        if (this.subjectsMatcher == null) {
            return true;
        }
        boolean valueMatches = this.subjectsMatcher.matches(selected);
        if (!valueMatches) {
            mismatchDescription.appendText(this.selector + " ");
            this.subjectsMatcher.describeMismatch(selected, mismatchDescription);
        }
        return valueMatches;
    }

    public void describeTo(Description description) {
        description.appendText("has selector \"");
        description.appendText(this.selector);
        description.appendText("\"");
        if (this.subjectsMatcher != null) {
            description.appendText(" ");
            this.subjectsMatcher.describeTo(description);
        }
    }

    @Factory
    public static Matcher<Element> hasSelector(String selector) {
        return new HasSelector(selector);
    }

    @Factory
    public static Matcher<Element> hasSelector(String selector, Matcher<? super Element> ... subjectsMatchers) {
        return HasSelector.hasSelector(selector, (Matcher<Iterable<Element>>)Matchers.hasItems(subjectsMatchers));
    }

    @Factory
    public static Matcher<Element> hasSelector(String selector, Matcher<Iterable<Element>> subjectsMatcher) {
        return new HasSelector(selector, subjectsMatcher);
    }
}

