/*
 * Decompiled with CFR 0.152.
 */
package org.testinfected.hamcrest.dom;

import com.google.common.collect.Iterables;
import com.threelevers.css.Selector;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.w3c.dom.Element;

public class HasNoSelector
extends TypeSafeDiagnosingMatcher<Element> {
    private String selector;

    public HasNoSelector(String selector) {
        this.selector = selector;
    }

    protected boolean matchesSafely(Element doc, Description mismatchDescription) {
        Iterable selected = Selector.from((Element)doc).select(this.selector);
        if (!Iterables.isEmpty((Iterable)selected)) {
            Element match = (Element)selected.iterator().next();
            mismatchDescription.appendText("matched element \"" + match.getTagName() + "\"");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("has no selector \"" + this.selector + "\"");
    }

    @Factory
    public static Matcher<Element> hasNoSelector(String selector) {
        return new HasNoSelector(selector);
    }
}

