/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.client.upload;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.testingisdocumenting.znai.client.ZipTask;
import org.testingisdocumenting.znai.client.upload.UploadPathValidator;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;

public class DocUploader {
    private static final String USER = System.getProperty("USER", "");
    private final String uploadUrl;
    private final String docId;
    private final Path path;
    private final String actor;

    private DocUploader(String uploadUrl, String docId, Path path, String actor) {
        this.uploadUrl = uploadUrl;
        this.docId = docId;
        this.path = path;
        this.actor = actor;
    }

    public static void upload(String uploadUrl, String docId, Path path, String actor) {
        new DocUploader(uploadUrl, docId, path, DocUploader.getActor(actor)).upload();
    }

    public static void uploadZip(String uploadUrl, String docId, Path path, String actor) {
        new DocUploader(uploadUrl, docId, path, DocUploader.getActor(actor)).uploadZip();
    }

    private void upload() {
        UploadPathValidator.validateFile(this.path, "index.html");
        UploadPathValidator.validateSize(this.path);
        Path zipPath = this.zipDocs(this.path);
        this.httpPut(zipPath);
    }

    private void uploadZip() {
        UploadPathValidator.validateSize(this.path);
        this.httpPut(this.path);
    }

    private void httpPut(Path zipPath) {
        ConsoleOutputs.out((Object[])new Object[]{Color.BLUE, "uploading documentation: ", Color.PURPLE, zipPath, Color.BLUE, " as ", Color.PURPLE, this.buildAccessUrl()});
        FileEntity entity = new FileEntity(zipPath.toFile(), ContentType.create((String)"application/octet-stream", (String)"UTF-8"));
        HttpPut put = new HttpPut(this.buildUploadUrl());
        put.setEntity((HttpEntity)entity);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)put);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                ConsoleOutputs.err((Object[])new Object[]{statusLine.toString()});
            } else {
                ConsoleOutputs.out((Object[])new Object[]{Color.BLUE, "upload finished"});
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String buildUploadUrl() {
        return this.uploadUrl + "/upload/" + this.docId + "?actor=" + this.actor;
    }

    private String buildAccessUrl() {
        return this.uploadUrl + "/" + this.docId;
    }

    private Path zipDocs(Path path) {
        ConsoleOutputs.out((Object[])new Object[]{Color.BLUE, "zipping: ", Color.PURPLE, path});
        Path zipDestination = Paths.get(this.docId + ".zip", new String[0]);
        zipDestination.toFile().deleteOnExit();
        ZipTask zipTask = new ZipTask(path, zipDestination);
        zipTask.execute();
        return zipDestination;
    }

    private static String getActor(String actor) {
        return StringUtils.isBlank((CharSequence)actor) ? USER : actor;
    }
}

