/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.graphviz.meta;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.testingisdocumenting.znai.diagrams.graphviz.meta.GraphvizNodeShape;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.JsonUtils;
import org.testingisdocumenting.znai.utils.ResourceUtils;

public class GraphvizShapeConfig {
    private Map<String, ?> config;
    private Map<String, String> svgByName;

    public GraphvizShapeConfig(String json) {
        this(JsonUtils.deserializeAsMap((String)json));
    }

    public GraphvizShapeConfig(Map<String, ?> config) {
        this.config = config;
        this.svgByName = this.buildSvgByName();
    }

    public Optional<String> shapeSvg(String style) {
        if (this.svgByName != null) {
            return Optional.ofNullable(this.svgByName.get(style));
        }
        Map<String, ?> c = this.getSubMap(style);
        if (c == null) {
            return Optional.empty();
        }
        String svg = (String)GraphvizShapeConfig.getValue(c, "svg");
        if (svg != null) {
            return Optional.of(svg);
        }
        String svgPath = (String)GraphvizShapeConfig.getValue(c, "svgPath");
        if (svgPath != null) {
            return this.loadSvg(svgPath);
        }
        return Optional.empty();
    }

    public boolean isInvertedTextColorByStyleId(String style) {
        Map<String, ?> c = this.getSubMap(style);
        if (c == null) {
            return false;
        }
        Boolean invertedText = (Boolean)GraphvizShapeConfig.getValue(c, "invertedText");
        return invertedText != null;
    }

    public Optional<GraphvizNodeShape> nodeShape(String style) {
        Map<String, ?> c = this.getSubMap(style);
        if (c == null) {
            return Optional.empty();
        }
        String shape = (String)GraphvizShapeConfig.getValue(c, "shape");
        String labelLoc = (String)GraphvizShapeConfig.getValue(c, "labelloc");
        Number width = (Number)GraphvizShapeConfig.getValue(c, "width");
        Number height = (Number)GraphvizShapeConfig.getValue(c, "height");
        return Optional.of(new GraphvizNodeShape(shape, labelLoc, width, height));
    }

    public Map<String, ?> getSvgByName() {
        return this.svgByName;
    }

    private Map<String, String> buildSvgByName() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.config.forEach((id, styleDef) -> {
            Optional<String> svg = this.shapeSvg((String)id);
            if (!svg.isPresent()) {
                throw new RuntimeException("no svg found for <" + id + ">");
            }
            result.put((String)id, svg.get());
        });
        return result;
    }

    private static <E> E getValue(Map<String, ?> map, String name) {
        return (E)map.get(name);
    }

    private Optional<String> loadSvg(String svgPath) {
        String svgFromResource = ResourceUtils.textContent((String)svgPath);
        if (svgFromResource != null) {
            return Optional.of(svgFromResource);
        }
        String svgFromFs = FileUtils.fileTextContent((Path)Paths.get(svgPath, new String[0]));
        return Optional.ofNullable(svgFromFs);
    }

    private Map<String, ?> getSubMap(String style) {
        return (Map)this.config.get(style);
    }
}

