/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.graphviz.meta;

import java.util.ArrayList;

public class GraphvizNodeShape {
    private final String shape;
    private final String labelLoc;
    private final Number width;
    private final Number height;

    public GraphvizNodeShape(String shape, String labelLoc, Number width, Number height) {
        this.shape = shape;
        this.labelLoc = labelLoc;
        this.width = width;
        this.height = height;
    }

    public String getShape() {
        return this.shape;
    }

    public Number getWidth() {
        return this.width;
    }

    public Number getHeight() {
        return this.height;
    }

    public boolean isShapeSet() {
        return this.shape != null && !this.shape.isEmpty();
    }

    public boolean isLabelLocSet() {
        return this.labelLoc != null && !this.labelLoc.isEmpty();
    }

    public boolean isWidthSet() {
        return this.width != null;
    }

    public boolean isHeightSet() {
        return this.height != null;
    }

    public String asAttrs() {
        ArrayList<String> attrs = new ArrayList<String>();
        if (this.isShapeSet()) {
            attrs.add("shape=" + this.shape);
        }
        if (this.isLabelLocSet()) {
            attrs.add("labelloc=" + this.labelLoc);
        }
        if (this.isWidthSet()) {
            attrs.add("width=" + this.width);
        }
        if (this.isHeightSet()) {
            attrs.add("height=" + this.height);
        }
        if (this.isWidthSet() || this.isHeightSet()) {
            attrs.add("fixedsize=true");
        }
        return String.join((CharSequence)"; ", attrs);
    }

    public String toString() {
        return this.asAttrs();
    }
}

