/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.mermaid;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.diagrams.mermaid.MermaidPluginParams;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class MermaidIncludePlugin
implements IncludePlugin {
    private Path mermaidPath;
    private String content;

    public String id() {
        return "mermaid";
    }

    public IncludePlugin create() {
        return new MermaidIncludePlugin();
    }

    public PluginParamsDefinition parameters() {
        return MermaidPluginParams.definition;
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.mermaidPath = componentsRegistry.resourceResolver().fullPath(pluginParams.getFreeParam());
        this.content = componentsRegistry.resourceResolver().textContent(this.mermaidPath);
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(pluginParams.getOpts().toMap());
        props.put("mermaid", this.content);
        return PluginResult.docElement((String)"Mermaid", props);
    }

    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime((Path)this.mermaidPath));
    }

    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.content);
    }
}

