/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class DiagramLegendIncludePlugin
implements IncludePlugin {
    private static final String CLICKABLE_NODES_NAME = "clickableNodes";
    private Map<String, String> legend;

    public String id() {
        return "diagram-legend";
    }

    public IncludePlugin create() {
        return new DiagramLegendIncludePlugin();
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        Boolean clickableNodes = (Boolean)pluginParams.getOpts().get(CLICKABLE_NODES_NAME, (Object)false);
        this.legend = this.extractLegend(pluginParams.getOpts());
        this.legend.remove(CLICKABLE_NODES_NAME);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("legend", this.legend);
        props.put(CLICKABLE_NODES_NAME, clickableNodes);
        return PluginResult.docElement((String)"DiagramLegend", props);
    }

    public List<SearchText> textForSearch() {
        return List.of(SearchScore.STANDARD.text(String.join((CharSequence)" ", this.legend.values())));
    }

    private Map<String, String> extractLegend(PluginParamsOpts opts) {
        HashMap<String, String> result = new HashMap<String, String>();
        opts.forEach((k, v) -> result.put((String)k, v.toString()));
        result.remove(CLICKABLE_NODES_NAME);
        return result;
    }
}

