/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.plantuml;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.diagrams.plantuml.PlantUml;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class PlantUmlFencePlugin
implements FencePlugin {
    private String plantUmlSource;

    public String id() {
        return "plantuml";
    }

    public FencePlugin create() {
        return new PlantUmlFencePlugin();
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        this.plantUmlSource = content;
        return PluginResult.docElement((String)"Svg", Collections.singletonMap("svg", PlantUml.generateSvg(content)));
    }

    public List<SearchText> textForSearch() {
        return this.plantUmlSource != null ? List.of(SearchScore.STANDARD.text(this.plantUmlSource)) : List.of();
    }
}

