/*
 * Copyright 2019 TWO SIGMA OPEN SOURCE, LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.testingisdocumenting.znai.diagrams.plantuml;

import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class PlantUmlFencePlugin implements FencePlugin {
    private String plantUmlSource;

    @Override
    public String id() {
        return "plantuml";
    }

    @Override
    public FencePlugin create() {
        return new PlantUmlFencePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        plantUmlSource = content;
        return PluginResult.docElement("Svg", Collections.singletonMap("svg", PlantUml.generateSvg(content)));
    }

    @Override
    public List<SearchText> textForSearch() {
        return plantUmlSource != null ? List.of(SearchScore.STANDARD.text(plantUmlSource)) : List.of();
    }
}
