/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.graphviz;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.diagrams.graphviz.GraphvizPlugin;
import org.testingisdocumenting.znai.diagrams.graphviz.GraphvizPluginParams;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class GraphvizIncludePlugin
implements IncludePlugin {
    private Path diagramPath;
    private String diagramContent;

    public String id() {
        return "graphviz";
    }

    public IncludePlugin create() {
        return new GraphvizIncludePlugin();
    }

    public PluginParamsDefinition parameters() {
        return GraphvizPluginParams.definition;
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.diagramPath = componentsRegistry.resourceResolver().fullPath(pluginParams.getFreeParam());
        this.diagramContent = componentsRegistry.resourceResolver().textContent(this.diagramPath);
        return GraphvizPlugin.pluginResult(componentsRegistry.globalAssetsRegistry(), pluginParams, this.diagramContent);
    }

    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime((Path)this.diagramPath));
    }

    public List<SearchText> textForSearch() {
        return this.diagramContent != null ? List.of(SearchScore.STANDARD.text(this.diagramContent)) : List.of();
    }
}

