/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.plantuml;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.diagrams.plantuml.PlantUml;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class PlantUmlIncludePlugin
implements IncludePlugin {
    private Path fullPath;
    private String plantUmlSource;

    public String id() {
        return "plantuml";
    }

    public IncludePlugin create() {
        return new PlantUmlIncludePlugin();
    }

    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        this.fullPath = resourcesResolver.fullPath(pluginParams.getFreeParam());
        this.plantUmlSource = resourcesResolver.textContent(this.fullPath);
        return PluginResult.docElement((String)"Svg", Collections.singletonMap("svg", PlantUml.generateSvg(this.plantUmlSource)));
    }

    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime((Path)this.fullPath));
    }

    public List<SearchText> textForSearch() {
        return this.plantUmlSource != null ? List.of(SearchScore.STANDARD.text(this.plantUmlSource)) : List.of();
    }
}

