/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise;

import org.testingisdocumenting.znai.enterprise.ZnaiEnterpriseConfig;
import org.testingisdocumenting.znai.enterprise.landing.LandingDocEntriesProviders;
import org.testingisdocumenting.znai.enterprise.storage.DocumentationStorage;
import org.testingisdocumenting.znai.enterprise.storage.FileBasedDocumentationStorage;
import org.testingisdocumenting.znai.server.ServerLifecycleListener;
import org.testingisdocumenting.znai.server.ZnaiServerConfig;

public class EnterpriseComponentsRegistry
implements ServerLifecycleListener {
    private static ZnaiServerConfig serverConfig;
    private static final ZnaiEnterpriseConfig enterpriseConfig;
    private static DocumentationStorage documentationStorage;

    @Override
    public void beforeStart(ZnaiServerConfig config) {
        serverConfig = config;
        documentationStorage = EnterpriseComponentsRegistry.createStorage();
    }

    public static DocumentationStorage documentationStorage() {
        return documentationStorage;
    }

    public static ZnaiEnterpriseConfig enterpriseConfig() {
        return enterpriseConfig;
    }

    public static ZnaiServerConfig serverConfig() {
        return serverConfig;
    }

    private static DocumentationStorage createStorage() {
        FileBasedDocumentationStorage documentationStorage = new FileBasedDocumentationStorage(EnterpriseComponentsRegistry.enterpriseConfig().getDocStorageRoot(), serverConfig.getDeployRoot());
        LandingDocEntriesProviders.add(documentationStorage);
        return documentationStorage;
    }

    static {
        enterpriseConfig = new ZnaiEnterpriseConfig();
    }
}

