/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.extensions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.file.SnippetContentProvider;
import org.testingisdocumenting.znai.extensions.file.SnippetHighlightFeature;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.java.extensions.JavaIncludePluginBase;
import org.testingisdocumenting.znai.java.extensions.JavaIncludeResult;
import org.testingisdocumenting.znai.java.parser.JavaCode;
import org.testingisdocumenting.znai.java.parser.JavaCodeUtils;
import org.testingisdocumenting.znai.java.parser.JavaMethod;
import org.testingisdocumenting.znai.java.parser.JavaType;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.utils.StringUtils;

public class JavaIncludePlugin
extends JavaIncludePluginBase
implements SnippetContentProvider {
    private PluginParamsOpts opts;
    private boolean isBodyOnly;
    private boolean isSignatureOnly;
    private boolean isMultipleEntries;
    private String snippet;

    @Override
    public String id() {
        return "java";
    }

    @Override
    public IncludePlugin create() {
        return new JavaIncludePlugin();
    }

    @Override
    public JavaIncludeResult process(JavaCode javaCode) {
        this.features.add(new SnippetHighlightFeature(this.componentsRegistry, this.pluginParams, this));
        this.opts = this.pluginParams.getOpts();
        this.isBodyOnly = this.opts.get("bodyOnly", false);
        this.isSignatureOnly = this.opts.get("signatureOnly", false);
        boolean bl = this.isMultipleEntries = !this.entries.isEmpty();
        if (this.isBodyOnly && this.isSignatureOnly) {
            throw new IllegalArgumentException("specify only bodyOnly or signatureOnly");
        }
        this.snippet = this.extractContent(javaCode);
        Map<String, Object> props = CodeSnippetsProps.create("java", this.snippet);
        props.putAll(this.pluginParams.getOpts().toMap());
        this.features.updateProps(props);
        DocElement docElement = new DocElement("Snippet");
        props.forEach(docElement::addProp);
        return new JavaIncludeResult(Collections.singletonList(docElement), this.snippet);
    }

    private String extractContent(JavaCode javaCode) {
        if (this.entry == null && this.entries.isEmpty()) {
            return javaCode.getFileContent();
        }
        Stream<String> methodNamesWithOptionalTypes = this.entry != null ? Stream.of(this.entry) : this.entries.stream();
        return methodNamesWithOptionalTypes.map(nameWithOptionalType -> this.extractSingleEntryContent(javaCode, (String)nameWithOptionalType)).collect(this.collectorWithSeparator());
    }

    private String extractSingleEntryContent(JavaCode javaCode, String entry) {
        return javaCode.hasType(entry) ? this.extractTypeContent(javaCode, entry) : this.extractMethodContent(javaCode, entry);
    }

    private String extractTypeContent(JavaCode javaCode, String entry) {
        JavaType type = javaCode.findType(entry);
        return this.isBodyOnly ? type.getBodyOnly() : type.getFullBody();
    }

    private String extractMethodContent(JavaCode javaCode, String entry) {
        List<JavaMethod> methods;
        List<JavaMethod> list = methods = this.isMultipleEntries ? javaCode.findAllMethods(entry) : Collections.singletonList(javaCode.findMethod(entry));
        if (this.isBodyOnly) {
            return this.extractBodiesOnly(methods);
        }
        if (this.isSignatureOnly) {
            return this.extractSignaturesOnly(methods);
        }
        return this.extractFullBodies(methods);
    }

    private String extractFullBodies(List<JavaMethod> methods) {
        return methods.stream().map(JavaMethod::getFullBody).collect(this.collectorWithSeparator());
    }

    private String extractBodiesOnly(List<JavaMethod> methods) {
        return methods.stream().map(this::extractBodyOnly).collect(this.collectorWithSeparator());
    }

    private String extractSignaturesOnly(List<JavaMethod> methods) {
        return methods.stream().map(JavaMethod::getSignatureOnly).collect(this.collectorWithSeparator());
    }

    private String extractBodyOnly(JavaMethod method) {
        String result = method.getBodyOnly();
        boolean removeReturn = this.opts.get("removeReturn", false);
        result = removeReturn ? StringUtils.stripIndentation(JavaCodeUtils.removeReturn(result)) : result;
        boolean removeSemicolon = this.opts.get("removeSemicolon", false);
        result = removeSemicolon ? JavaCodeUtils.removeSemicolonAtEnd(result) : result;
        return result;
    }

    private Collector<CharSequence, ?, String> collectorWithSeparator() {
        return Collectors.joining(this.isSignatureOnly ? "\n" : "\n\n");
    }

    @Override
    public String snippetContent() {
        return this.snippet;
    }

    @Override
    public String snippetId() {
        return this.path;
    }
}

