/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.openapi;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.openapi.OpenApiOperation;
import org.testingisdocumenting.znai.openapi.OpenApiParameter;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import org.testingisdocumenting.znai.utils.JsonUtils;
import org.testingisdocumenting.znai.utils.YamlUtils;

public class OpenApiSpec {
    private static final String DESCRIPTION_KEY = "description";
    private static final String REF_KEY = "$ref";
    private static final String ALL_OFF_KEY = "allOf";
    private final String basePath;
    private MarkdownParser markdownParser;
    private Map<String, ?> spec;
    private List<OpenApiOperation> operations;

    public static OpenApiSpec fromJson(MarkdownParser markdownParser, String jsonSpec) {
        return new OpenApiSpec(markdownParser, JsonUtils.deserializeAsMap(jsonSpec));
    }

    public static OpenApiSpec fromYaml(MarkdownParser markdownParser, String yamlSpec) {
        return new OpenApiSpec(markdownParser, YamlUtils.deserializeAsMap(yamlSpec));
    }

    public OpenApiSpec(MarkdownParser markdownParser, Map<String, ?> spec) {
        this.markdownParser = markdownParser;
        this.spec = spec;
        this.basePath = this.extractBasePath(spec);
        this.operations = new ArrayList<OpenApiOperation>();
        this.parse();
    }

    public OpenApiOperation findOperationById(String operationId) {
        return this.operations.stream().filter(o -> operationId.equals(o.getId())).findFirst().orElseThrow(() -> new RuntimeException("cannot find operation: " + operationId));
    }

    public OpenApiOperation findOperationByMethodAndPath(String method, String path2) {
        return this.operations.stream().filter(o -> o.matches(method, path2)).findFirst().orElseThrow(() -> new RuntimeException("cannot find operation: " + method + " " + path2));
    }

    public List<OpenApiOperation> findOperationsByTags(List<String> tags) {
        return this.operations.stream().filter(o -> o.hasTags(tags)).collect(Collectors.toList());
    }

    public List<OpenApiOperation> getOperations() {
        return this.operations;
    }

    private void parse() {
        this.parsePaths((Map)this.spec.get("paths"));
    }

    private void parsePaths(Map<String, ?> paths) {
        if (paths == null) {
            throw new IllegalArgumentException("no paths definition found in the spec");
        }
        paths.forEach((path2, methods) -> this.parseMethods((String)path2, (Map)methods));
    }

    private void parseMethods(String path2, Map<String, ?> methodsWithShared) {
        LinkedHashMap shared = new LinkedHashMap();
        LinkedHashMap<String, Object> methods = new LinkedHashMap<String, Object>();
        methodsWithShared.forEach((methodWithShared, definition) -> {
            if (this.isShared((String)methodWithShared)) {
                shared.put(methodWithShared, definition);
            } else {
                methods.put((String)methodWithShared, definition);
            }
        });
        methods.forEach((method, definition) -> {
            shared.forEach(((Map)definition)::put);
            this.parseMethod(path2, (String)method, (Map)definition);
        });
    }

    private boolean isShared(String field) {
        return "parameters".equals(field) || REF_KEY.equals(field);
    }

    private void parseMethod(String path2, String method, Map<String, ?> definition) {
        OpenApiOperation operation = new OpenApiOperation();
        operation.setId(Objects.toString(definition.get("operationId")));
        operation.setTags((List)definition.get("tags"));
        operation.setPath(this.fullPath(path2));
        operation.setMethod(method);
        operation.setConsumes(this.listOrDefault(definition, "consumes"));
        operation.setProduces(this.listOrDefault(definition, "produces"));
        operation.setSummary(Objects.toString(definition.get("summary")));
        operation.setDescription(this.parseMarkdown(definition.get(DESCRIPTION_KEY)));
        operation.setResponses(this.buildResponses((Map)definition.get("responses")));
        operation.setParameters(this.buildParameters((List)definition.get("parameters")));
        this.operations.add(operation);
    }

    private String fullPath(String path2) {
        if (this.basePath.endsWith("/") && !path2.startsWith("/")) {
            return this.basePath + path2;
        }
        if (!this.basePath.endsWith("/") && path2.startsWith("/")) {
            return this.basePath + path2;
        }
        if (this.basePath.endsWith("/") && path2.startsWith("/")) {
            return this.basePath + path2.substring(1);
        }
        return this.basePath + "/" + path2;
    }

    private List<String> listOrDefault(Map<String, ?> definition, String name) {
        Object def = definition.get(name);
        return (List)(def != null ? def : this.spec.get(name));
    }

    private List<OpenApiParameter> buildParameters(List<Map<String, ?>> parameters) {
        if (parameters == null) {
            return Collections.emptyList();
        }
        return parameters.stream().map(this::buildParameter).collect(Collectors.toList());
    }

    private String extractBasePath(Map<String, ?> spec) {
        Object basePath = spec.get("basePath");
        return basePath == null ? "/" : basePath.toString();
    }

    private OpenApiParameter buildParameter(Map<String, ?> parameter) {
        return new OpenApiParameter(Objects.toString(parameter.get("name")), Objects.toString(parameter.get("in")), Objects.toString(parameter.get("type")), this.getBoolean(parameter, "required", false), this.buildParameterSchema((Map)parameter.get("schema")), this.parseMarkdown(parameter.get(DESCRIPTION_KEY)));
    }

    private boolean getBoolean(Map<String, ?> map, String name, Boolean defaultValue) {
        Object v = map.get(name);
        return v == null ? defaultValue.booleanValue() : ((Boolean)v).booleanValue();
    }

    private Map<String, ?> buildParameterSchema(Map<String, ?> schema) {
        if (schema == null) {
            return Collections.emptyMap();
        }
        return this.substituteSchema(schema);
    }

    private List<Map<String, ?>> buildResponses(Map<String, ?> specResponses) {
        ArrayList responses = new ArrayList();
        specResponses.forEach((code, response) -> responses.add(this.buildResponse((String)code, (Map)response)));
        return responses;
    }

    private Map<String, ?> buildResponse(String code, Map<String, ?> response) {
        LinkedHashMap<String, String> normalized = new LinkedHashMap<String, String>();
        normalized.put("code", code);
        normalized.putAll(this.substituteSchema(response));
        return normalized;
    }

    private Map<String, ?> substituteSchema(Map<String, ?> data) {
        HashMap substituted = new HashMap();
        if (data == null) {
            return substituted;
        }
        data.forEach((k, v) -> {
            if (k.equals(DESCRIPTION_KEY) && v instanceof String) {
                substituted.put(DESCRIPTION_KEY, this.parseMarkdown(v));
                return;
            }
            switch (k) {
                case "$ref": {
                    substituted.putAll((Map)this.substituteValue((String)k, v));
                    break;
                }
                case "allOf": {
                    substituted.putAll(this.combineAllOfProperties((List)v));
                    break;
                }
                default: {
                    substituted.put(k, this.substituteValue((String)k, v));
                }
            }
        });
        return substituted;
    }

    private Map<String, ?> combineAllOfProperties(List<Map<String, ?>> parts) {
        LinkedHashMap combined = new LinkedHashMap();
        LinkedHashMap properties = new LinkedHashMap();
        combined.put("properties", properties);
        parts.forEach(p -> {
            Map<String, ?> substituted = this.substituteSchema((Map<String, ?>)p);
            properties.putAll((Map)substituted.get("properties"));
        });
        return combined;
    }

    private Object substituteValue(String k, Object v) {
        if (k.equals(REF_KEY)) {
            return this.schemaByPath(v.toString());
        }
        if (v instanceof Map) {
            return this.substituteSchema((Map)v);
        }
        return v;
    }

    private Object schemaByPath(String path2) {
        if (!path2.startsWith("#")) {
            throw new IllegalArgumentException("definition path is not supported: " + path2);
        }
        String[] pathParts = path2.split("/");
        String[] pathFromRoot = Arrays.copyOfRange(pathParts, 1, pathParts.length);
        return this.specValueByPath(pathFromRoot);
    }

    private Object specValueByPath(String[] pathParts) {
        Map data = this.spec;
        for (int i = 0; i < pathParts.length - 1; ++i) {
            data = (Map)data.get(pathParts[i]);
        }
        return this.substituteSchema((Map)data.get(pathParts[pathParts.length - 1]));
    }

    private List<Map<String, Object>> parseMarkdown(Object markdown) {
        if (markdown == null) {
            return Collections.emptyList();
        }
        MarkupParserResult parserResult = this.markdownParser.parse(Paths.get("", new String[0]), markdown.toString());
        return parserResult.getDocElement().contentToListOfMaps();
    }
}

