/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.commonmark;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.ParserHandlersList;
import org.testingisdocumenting.znai.parser.commonmark.CommonMarkExtension;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownVisitor;
import org.testingisdocumenting.znai.parser.docelement.DocElementCreationParserHandler;
import org.testingisdocumenting.znai.search.SearchCrawlerParserHandler;
import org.testingisdocumenting.znai.structure.PageMeta;
import znaishaded.org.commonmark.ext.front.matter.YamlFrontMatterExtension;
import znaishaded.org.commonmark.ext.front.matter.YamlFrontMatterVisitor;
import znaishaded.org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import znaishaded.org.commonmark.ext.gfm.tables.TablesExtension;
import znaishaded.org.commonmark.node.Node;
import znaishaded.org.commonmark.parser.Parser;

public class MarkdownParser
implements MarkupParser {
    private final Parser fullParser;
    private final Parser metaOnlyParser;
    private final ComponentsRegistry componentsRegistry;

    public MarkdownParser(ComponentsRegistry componentsRegistry) {
        this.componentsRegistry = componentsRegistry;
        CommonMarkExtension extension = new CommonMarkExtension();
        this.fullParser = Parser.builder().extensions(Arrays.asList(extension, TablesExtension.create(), StrikethroughExtension.create(), YamlFrontMatterExtension.create())).build();
        this.metaOnlyParser = Parser.builder().extensions(Collections.singletonList(YamlFrontMatterExtension.create())).build();
    }

    @Override
    public MarkupParserResult parse(Path path2, String markdown) {
        SearchCrawlerParserHandler searchCrawler = new SearchCrawlerParserHandler();
        DocElementCreationParserHandler elementCreationHandler = new DocElementCreationParserHandler(this.componentsRegistry, path2);
        ParserHandlersList parserHandler = new ParserHandlersList(elementCreationHandler, searchCrawler);
        Node node = this.fullParser.parse(markdown);
        MarkdownVisitor visitor = this.parsePartial(node, path2, parserHandler);
        if (visitor.isSectionStarted()) {
            parserHandler.onSectionEnd();
        }
        parserHandler.onParsingEnd();
        return new MarkupParserResult(elementCreationHandler.getDocElement(), elementCreationHandler.getGlobalAnchorIds(), searchCrawler.getSearchEntries(), elementCreationHandler.getAuxiliaryFiles(), this.parsePageMeta(node));
    }

    @Override
    public PageMeta parsePageMetaOnly(String markdown) {
        Node node = this.metaOnlyParser.parse(markdown);
        return this.parsePageMeta(node);
    }

    public void parse(Path path2, String markdown, ParserHandler handler) {
        Node node = this.fullParser.parse(markdown);
        this.parsePartial(node, path2, handler);
    }

    private MarkdownVisitor parsePartial(Node node, Path path2, ParserHandler handler) {
        MarkdownVisitor visitor = new MarkdownVisitor(this.componentsRegistry, path2, handler);
        node.accept(visitor);
        return visitor;
    }

    private PageMeta parsePageMeta(Node node) {
        YamlFrontMatterVisitor frontMatterVisitor = new YamlFrontMatterVisitor();
        node.accept(frontMatterVisitor);
        return new PageMeta(frontMatterVisitor.getData());
    }
}

