/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.ctreber.acearth.scanbit;

import java.util.ArrayList;
import java.util.List;
import znaishaded.com.ctreber.acearth.scanbit.ScanBit;
import znaishaded.com.ctreber.aclib.sort.QuickSort;

class ScanBuf {
    private List[] fScanbuf;
    private int fLineMin;
    private int fLineMax;
    private final int fLines;
    private final int fPoints;
    private boolean fScanBufsAdded;

    public ScanBuf(int n, int n2) {
        this.fLines = n;
        this.fPoints = n2;
        this.fLineMin = Integer.MAX_VALUE;
        this.fLineMax = Integer.MIN_VALUE;
        this.fScanBufsAdded = false;
        this.fScanbuf = new ArrayList[this.fLines];
        for (int i = 0; i < this.fScanbuf.length; ++i) {
            this.fScanbuf[i] = new ArrayList();
        }
    }

    public void addLine(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        if (d2 < d4) {
            n2 = (int)Math.ceil(d2 - 0.5);
            n = (int)Math.floor(d4 - 0.5);
            if ((double)n == d4 - 0.5) {
                --n;
            }
        } else {
            n2 = (int)Math.ceil(d4 - 0.5);
            n = (int)Math.floor(d2 - 0.5);
            if ((double)n == d2 - 0.5) {
                --n;
            }
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n >= this.fLines) {
            n = this.fLines - 1;
        }
        if (n2 > n) {
            return;
        }
        if (n2 < this.fLineMin) {
            this.fLineMin = n2;
        }
        if (n > this.fLineMax) {
            this.fLineMax = n;
        }
        double d5 = (d3 - d) / (d4 - d2);
        double d6 = d + d5 * ((double)n2 + 0.5 - d2);
        for (int i = n2; i <= n; ++i) {
            this.fScanbuf[i].add(new Double(d6));
            d6 += d5;
        }
        this.fScanBufsAdded = true;
    }

    public boolean containsPoints() {
        return this.fScanBufsAdded;
    }

    public List getScanbits(int n) {
        ArrayList<ScanBit> arrayList = new ArrayList<ScanBit>();
        for (int i = this.fLineMin; i <= this.fLineMax; ++i) {
            Object[] objectArray = this.fScanbuf[i].toArray(new Double[0]);
            QuickSort quickSort = new QuickSort();
            quickSort.sort(objectArray);
            for (int j = 0; j < objectArray.length; j += 2) {
                int n2 = (int)Math.ceil((Double)objectArray[j] - 0.5);
                int n3 = (int)Math.floor((Double)objectArray[j + 1] - 0.5);
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n3 >= this.fPoints) {
                    n3 = this.fPoints - 1;
                }
                if (n2 > n3) continue;
                arrayList.add(new ScanBit(i, n2, n3, n));
            }
        }
        return arrayList;
    }

    public int getYMax() {
        return this.fLineMax;
    }

    public int getYMin() {
        return this.fLineMin;
    }
}

