/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.io.IOException;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.Interpolation;
import znaishaded.freemarker.core.ParameterRole;
import znaishaded.freemarker.template.TemplateException;
import znaishaded.freemarker.template.utility.StringUtil;

final class DollarVariable
extends Interpolation {
    private final Expression expression;
    private final Expression escapedExpression;

    DollarVariable(Expression expression, Expression escapedExpression) {
        this.expression = expression;
        this.escapedExpression = escapedExpression;
    }

    void accept(Environment env) throws TemplateException, IOException {
        env.getOut().write(this.escapedExpression.evalAndCoerceToString(env));
    }

    protected String dump(boolean canonical, boolean inStringLiteral) {
        StringBuffer sb = new StringBuffer();
        sb.append("${");
        String exprCF = this.expression.getCanonicalForm();
        sb.append(inStringLiteral ? StringUtil.FTLStringLiteralEnc(exprCF, '\"') : exprCF);
        sb.append("}");
        if (!canonical && this.expression != this.escapedExpression) {
            sb.append(" auto-escaped");
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return "${...}";
    }

    boolean heedsOpeningWhitespace() {
        return true;
    }

    boolean heedsTrailingWhitespace() {
        return true;
    }

    int getParameterCount() {
        return 1;
    }

    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.expression;
    }

    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.CONTENT;
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

