/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.dns;

import java.util.ArrayList;
import java.util.Base64;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.dns.AddressResolverOptions;
import znaishaded.io.vertx.core.json.JsonArray;
import znaishaded.io.vertx.core.json.JsonObject;

public class AddressResolverOptionsConverter {
    public static void fromJson(JsonObject json, AddressResolverOptions obj) {
        ArrayList<String> list;
        if (json.getValue("cacheMaxTimeToLive") instanceof Number) {
            obj.setCacheMaxTimeToLive(((Number)json.getValue("cacheMaxTimeToLive")).intValue());
        }
        if (json.getValue("cacheMinTimeToLive") instanceof Number) {
            obj.setCacheMinTimeToLive(((Number)json.getValue("cacheMinTimeToLive")).intValue());
        }
        if (json.getValue("cacheNegativeTimeToLive") instanceof Number) {
            obj.setCacheNegativeTimeToLive(((Number)json.getValue("cacheNegativeTimeToLive")).intValue());
        }
        if (json.getValue("hostsPath") instanceof String) {
            obj.setHostsPath((String)json.getValue("hostsPath"));
        }
        if (json.getValue("hostsValue") instanceof String) {
            obj.setHostsValue(Buffer.buffer(Base64.getDecoder().decode((String)json.getValue("hostsValue"))));
        }
        if (json.getValue("maxQueries") instanceof Number) {
            obj.setMaxQueries(((Number)json.getValue("maxQueries")).intValue());
        }
        if (json.getValue("ndots") instanceof Number) {
            obj.setNdots(((Number)json.getValue("ndots")).intValue());
        }
        if (json.getValue("optResourceEnabled") instanceof Boolean) {
            obj.setOptResourceEnabled((Boolean)json.getValue("optResourceEnabled"));
        }
        if (json.getValue("queryTimeout") instanceof Number) {
            obj.setQueryTimeout(((Number)json.getValue("queryTimeout")).longValue());
        }
        if (json.getValue("rdFlag") instanceof Boolean) {
            obj.setRdFlag((Boolean)json.getValue("rdFlag"));
        }
        if (json.getValue("rotateServers") instanceof Boolean) {
            obj.setRotateServers((Boolean)json.getValue("rotateServers"));
        }
        if (json.getValue("searchDomains") instanceof JsonArray) {
            list = new ArrayList<String>();
            json.getJsonArray("searchDomains").forEach(item2 -> {
                if (item2 instanceof String) {
                    list.add((String)item2);
                }
            });
            obj.setSearchDomains(list);
        }
        if (json.getValue("servers") instanceof JsonArray) {
            list = new ArrayList();
            json.getJsonArray("servers").forEach(item2 -> {
                if (item2 instanceof String) {
                    list.add((String)item2);
                }
            });
            obj.setServers(list);
        }
    }

    public static void toJson(AddressResolverOptions obj, JsonObject json) {
        JsonArray array;
        json.put("cacheMaxTimeToLive", obj.getCacheMaxTimeToLive());
        json.put("cacheMinTimeToLive", obj.getCacheMinTimeToLive());
        json.put("cacheNegativeTimeToLive", obj.getCacheNegativeTimeToLive());
        if (obj.getHostsPath() != null) {
            json.put("hostsPath", obj.getHostsPath());
        }
        if (obj.getHostsValue() != null) {
            json.put("hostsValue", obj.getHostsValue().getBytes());
        }
        json.put("maxQueries", obj.getMaxQueries());
        json.put("ndots", obj.getNdots());
        json.put("optResourceEnabled", obj.isOptResourceEnabled());
        json.put("queryTimeout", obj.getQueryTimeout());
        json.put("rdFlag", obj.getRdFlag());
        json.put("rotateServers", obj.isRotateServers());
        if (obj.getSearchDomains() != null) {
            array = new JsonArray();
            obj.getSearchDomains().forEach(item2 -> array.add((String)item2));
            json.put("searchDomains", array);
        }
        if (obj.getServers() != null) {
            array = new JsonArray();
            obj.getServers().forEach(item2 -> array.add((String)item2));
            json.put("servers", array);
        }
    }
}

