/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.buffer.Unpooled;
import znaishaded.io.netty.handler.codec.compression.ZlibWrapper;
import znaishaded.io.netty.handler.codec.http.HttpContentCompressor;
import znaishaded.io.netty.handler.codec.http.HttpHeaderNames;
import znaishaded.io.netty.handler.codec.http.QueryStringDecoder;
import znaishaded.io.netty.handler.codec.http2.Http2Headers;
import znaishaded.io.netty.util.AsciiString;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.CaseInsensitiveHeaders;
import znaishaded.io.vertx.core.http.Http2Settings;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.http.HttpVersion;

public final class HttpUtils {
    private static final CustomCompressor compressor = new CustomCompressor();
    private static final AsciiString TIMEOUT_EQ = AsciiString.of("timeout=");

    private HttpUtils() {
    }

    private static int indexOfSlash(CharSequence str, int start) {
        for (int i = start; i < str.length(); ++i) {
            if (str.charAt(i) != '/') continue;
            return i;
        }
        return -1;
    }

    private static boolean matches(CharSequence path2, int start, String what) {
        return HttpUtils.matches(path2, start, what, false);
    }

    private static boolean matches(CharSequence path2, int start, String what, boolean exact) {
        if (exact && path2.length() - start != what.length()) {
            return false;
        }
        if (path2.length() - start >= what.length()) {
            for (int i = 0; i < what.length(); ++i) {
                if (path2.charAt(start + i) == what.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String removeDots(CharSequence path2) {
        if (path2 == null) {
            return null;
        }
        StringBuilder obuf = new StringBuilder(path2.length());
        int i = 0;
        while (i < path2.length()) {
            int pos;
            if (HttpUtils.matches(path2, i, "./")) {
                i += 2;
                continue;
            }
            if (HttpUtils.matches(path2, i, "../")) {
                i += 3;
                continue;
            }
            if (HttpUtils.matches(path2, i, "/./")) {
                i += 2;
                continue;
            }
            if (HttpUtils.matches(path2, i, "/.", true)) {
                path2 = "/";
                i = 0;
                continue;
            }
            if (HttpUtils.matches(path2, i, "/../")) {
                i += 3;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (HttpUtils.matches(path2, i, "/..", true)) {
                path2 = "/";
                i = 0;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (HttpUtils.matches(path2, i, ".", true) || HttpUtils.matches(path2, i, "..", true)) break;
            if (path2.charAt(i) == '/') {
                ++i;
                if (obuf.length() == 0 || obuf.charAt(obuf.length() - 1) != '/') {
                    obuf.append('/');
                }
            }
            if ((pos = HttpUtils.indexOfSlash(path2, i)) != -1) {
                obuf.append(path2, i, pos);
                i = pos;
                continue;
            }
            obuf.append(path2, i, path2.length());
            break;
        }
        return obuf.toString();
    }

    public static URI resolveURIReference(String base, String ref) throws URISyntaxException {
        return HttpUtils.resolveURIReference(URI.create(base), ref);
    }

    public static URI resolveURIReference(URI base, String ref) throws URISyntaxException {
        String query;
        String path2;
        String authority;
        String scheme;
        URI _ref = URI.create(ref);
        if (_ref.getScheme() != null) {
            scheme = _ref.getScheme();
            authority = _ref.getAuthority();
            path2 = HttpUtils.removeDots(_ref.getPath());
            query = _ref.getRawQuery();
        } else {
            if (_ref.getAuthority() != null) {
                authority = _ref.getAuthority();
                path2 = _ref.getPath();
                query = _ref.getRawQuery();
            } else {
                if (_ref.getPath().length() == 0) {
                    path2 = base.getPath();
                    query = _ref.getRawQuery() != null ? _ref.getRawQuery() : base.getRawQuery();
                } else {
                    if (_ref.getPath().startsWith("/")) {
                        path2 = HttpUtils.removeDots(_ref.getPath());
                    } else {
                        int index;
                        String basePath = base.getPath();
                        String mergedPath = base.getAuthority() != null && basePath.length() == 0 ? "/" + _ref.getPath() : ((index = basePath.lastIndexOf(47)) > -1 ? basePath.substring(0, index + 1) + _ref.getPath() : _ref.getPath());
                        path2 = HttpUtils.removeDots(mergedPath);
                    }
                    query = _ref.getRawQuery();
                }
                authority = base.getAuthority();
            }
            scheme = base.getScheme();
        }
        return new URI(scheme, authority, path2, query, _ref.getFragment());
    }

    static String parsePath(String uri) {
        int i;
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
        }
        return uri.substring(i, queryStart);
    }

    static String parseQuery(String uri) {
        int i = uri.indexOf(63);
        if (i == -1) {
            return null;
        }
        return uri.substring(i + 1, uri.length());
    }

    static String absoluteURI(String serverOrigin, HttpServerRequest req) throws URISyntaxException {
        String host;
        URI uri = new URI(req.uri());
        String scheme = uri.getScheme();
        String absoluteURI = scheme != null && (scheme.equals("http") || scheme.equals("https")) ? uri.toString() : ((host = req.host()) != null ? req.scheme() + "://" + host + uri : serverOrigin + uri);
        return absoluteURI;
    }

    static MultiMap params(String uri) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri);
        Map<String, List<String>> prms = queryStringDecoder.parameters();
        CaseInsensitiveHeaders params = new CaseInsensitiveHeaders();
        if (!prms.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : prms.entrySet()) {
                params.add(entry.getKey(), (Iterable<String>)entry.getValue());
            }
        }
        return params;
    }

    public static void fromVertxInitialSettings(boolean server, Http2Settings vertxSettings, znaishaded.io.netty.handler.codec.http2.Http2Settings nettySettings) {
        if (vertxSettings != null) {
            Map<Integer, Long> extraSettings;
            if (!server && !vertxSettings.isPushEnabled()) {
                nettySettings.pushEnabled(vertxSettings.isPushEnabled());
            }
            if (vertxSettings.getHeaderTableSize() != 4096L) {
                nettySettings.put('\u0001', vertxSettings.getHeaderTableSize());
            }
            if (vertxSettings.getInitialWindowSize() != 65535) {
                nettySettings.initialWindowSize(vertxSettings.getInitialWindowSize());
            }
            if (vertxSettings.getMaxConcurrentStreams() != 0xFFFFFFFFL) {
                nettySettings.maxConcurrentStreams(vertxSettings.getMaxConcurrentStreams());
            }
            if (vertxSettings.getMaxFrameSize() != 16384) {
                nettySettings.maxFrameSize(vertxSettings.getMaxFrameSize());
            }
            if (vertxSettings.getMaxHeaderListSize() != Integer.MAX_VALUE) {
                nettySettings.maxHeaderListSize(vertxSettings.getMaxHeaderListSize());
            }
            if ((extraSettings = vertxSettings.getExtraSettings()) != null) {
                extraSettings.forEach((code, setting) -> nettySettings.put((char)code.intValue(), (Long)setting));
            }
        }
    }

    public static znaishaded.io.netty.handler.codec.http2.Http2Settings fromVertxSettings(Http2Settings settings) {
        znaishaded.io.netty.handler.codec.http2.Http2Settings converted = new znaishaded.io.netty.handler.codec.http2.Http2Settings();
        converted.pushEnabled(settings.isPushEnabled());
        converted.maxFrameSize(settings.getMaxFrameSize());
        converted.initialWindowSize(settings.getInitialWindowSize());
        converted.headerTableSize(settings.getHeaderTableSize());
        converted.maxConcurrentStreams(settings.getMaxConcurrentStreams());
        converted.maxHeaderListSize(settings.getMaxHeaderListSize());
        if (settings.getExtraSettings() != null) {
            settings.getExtraSettings().forEach((key, value) -> converted.put((char)key.intValue(), (Long)value));
        }
        return converted;
    }

    public static Http2Settings toVertxSettings(znaishaded.io.netty.handler.codec.http2.Http2Settings settings) {
        Long headerTableSize;
        Integer initialWindowSize;
        Integer maxFrameSize;
        Long maxHeaderListSize;
        Long maxConcurrentStreams;
        Http2Settings converted = new Http2Settings();
        Boolean pushEnabled = settings.pushEnabled();
        if (pushEnabled != null) {
            converted.setPushEnabled(pushEnabled);
        }
        if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
            converted.setMaxConcurrentStreams(maxConcurrentStreams);
        }
        if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
            converted.setMaxHeaderListSize(maxHeaderListSize);
        }
        if ((maxFrameSize = settings.maxFrameSize()) != null) {
            converted.setMaxFrameSize(maxFrameSize);
        }
        if ((initialWindowSize = settings.initialWindowSize()) != null) {
            converted.setInitialWindowSize(initialWindowSize);
        }
        if ((headerTableSize = settings.headerTableSize()) != null) {
            converted.setHeaderTableSize(headerTableSize);
        }
        settings.forEach((key, value) -> {
            if (key.charValue() > '\u0006') {
                converted.set(key.charValue(), (long)value);
            }
        });
        return converted;
    }

    static znaishaded.io.netty.handler.codec.http2.Http2Settings decodeSettings(String base64Settings) {
        try {
            znaishaded.io.netty.handler.codec.http2.Http2Settings settings = new znaishaded.io.netty.handler.codec.http2.Http2Settings();
            Buffer buffer = Buffer.buffer(Base64.getUrlDecoder().decode(base64Settings));
            int len = buffer.length();
            for (int pos = 0; pos < len; pos += 4) {
                int i = buffer.getUnsignedShort(pos);
                long j = buffer.getUnsignedInt(pos += 2);
                settings.put((char)i, j);
            }
            return settings;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encodeSettings(Http2Settings settings) {
        Buffer buffer = Buffer.buffer();
        HttpUtils.fromVertxSettings(settings).forEach((c, l) -> {
            buffer.appendUnsignedShort(c.charValue());
            buffer.appendUnsignedInt((long)l);
        });
        return Base64.getUrlEncoder().encodeToString(buffer.getBytes());
    }

    public static ByteBuf generateWSCloseFrameByteBuf(short statusCode, String reason) {
        if (reason != null) {
            return Unpooled.copiedBuffer(Unpooled.copyShort((int)statusCode), Unpooled.copiedBuffer(reason, Charset.forName("UTF-8")));
        }
        return Unpooled.copyShort((int)statusCode);
    }

    static String determineContentEncoding(Http2Headers headers) {
        ZlibWrapper wrapper;
        String acceptEncoding;
        String string = acceptEncoding = headers.get(HttpHeaderNames.ACCEPT_ENCODING) != null ? ((CharSequence)headers.get(HttpHeaderNames.ACCEPT_ENCODING)).toString() : null;
        if (acceptEncoding != null && (wrapper = compressor.determineWrapper(acceptEncoding)) != null) {
            switch (wrapper) {
                case GZIP: {
                    return "gzip";
                }
                case ZLIB: {
                    return "deflate";
                }
            }
        }
        return null;
    }

    static znaishaded.io.netty.handler.codec.http.HttpMethod toNettyHttpMethod(HttpMethod method, String rawMethod) {
        switch (method) {
            case CONNECT: {
                return znaishaded.io.netty.handler.codec.http.HttpMethod.CONNECT;
            }
            case GET: {
                return znaishaded.io.netty.handler.codec.http.HttpMethod.GET;
            }
            case PUT: {
                return znaishaded.io.netty.handler.codec.http.HttpMethod.PUT;
            }
            case POST: {
                return znaishaded.io.netty.handler.codec.http.HttpMethod.POST;
            }
            case DELETE: {
                return znaishaded.io.netty.handler.codec.http.HttpMethod.DELETE;
            }
            case HEAD: {
                return znaishaded.io.netty.handler.codec.http.HttpMethod.HEAD;
            }
            case OPTIONS: {
                return znaishaded.io.netty.handler.codec.http.HttpMethod.OPTIONS;
            }
            case TRACE: {
                return znaishaded.io.netty.handler.codec.http.HttpMethod.TRACE;
            }
            case PATCH: {
                return znaishaded.io.netty.handler.codec.http.HttpMethod.PATCH;
            }
        }
        return znaishaded.io.netty.handler.codec.http.HttpMethod.valueOf(rawMethod);
    }

    static znaishaded.io.netty.handler.codec.http.HttpVersion toNettyHttpVersion(HttpVersion version) {
        switch (version) {
            case HTTP_1_0: {
                return znaishaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_0;
            }
            case HTTP_1_1: {
                return znaishaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_1;
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP version: " + (Object)((Object)version));
    }

    static HttpVersion toVertxHttpVersion(znaishaded.io.netty.handler.codec.http.HttpVersion version) {
        if (version == znaishaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_0) {
            return HttpVersion.HTTP_1_0;
        }
        if (version == znaishaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
            return HttpVersion.HTTP_1_1;
        }
        return null;
    }

    static HttpMethod toVertxMethod(String method) {
        try {
            return HttpMethod.valueOf(method);
        }
        catch (IllegalArgumentException e) {
            return HttpMethod.OTHER;
        }
    }

    public static int parseKeepAliveHeaderTimeout(CharSequence value) {
        int len = value.length();
        int pos = 0;
        while (pos < len) {
            int to;
            int next;
            int idx = AsciiString.indexOf(value, ',', pos);
            if (idx == -1) {
                idx = next = len;
            } else {
                next = idx + 1;
            }
            while (pos < idx && value.charAt(pos) == ' ') {
                ++pos;
            }
            for (to = idx; to > pos && value.charAt(to - 1) == ' '; --to) {
            }
            if (AsciiString.regionMatches(value, true, pos, TIMEOUT_EQ, 0, TIMEOUT_EQ.length()) && (pos += TIMEOUT_EQ.length()) < to) {
                int ret = 0;
                while (pos < to) {
                    char ch;
                    if ((ch = value.charAt(pos++)) >= '0' && ch < '9') {
                        ret = ret * 10 + (ch - 48);
                        continue;
                    }
                    ret = -1;
                    break;
                }
                if (ret > -1) {
                    return ret;
                }
            }
            pos = next;
        }
        return -1;
    }

    public static void validateHeader(CharSequence name, CharSequence value) {
        HttpUtils.validateHeader(name);
        HttpUtils.validateHeader(value);
    }

    public static void validateHeader(CharSequence name, Iterable<? extends CharSequence> values) {
        HttpUtils.validateHeader(name);
        values.forEach(HttpUtils::validateHeader);
    }

    public static void validateHeader(CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != '\r' && c != '\n') continue;
            throw new IllegalArgumentException("Illegal header character: " + c);
        }
    }

    private static class CustomCompressor
    extends HttpContentCompressor {
        private CustomCompressor() {
        }

        @Override
        public ZlibWrapper determineWrapper(String acceptEncoding) {
            return super.determineWrapper(acceptEncoding);
        }
    }
}

