/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.handler.codec.http.multipart.FileUpload;
import znaishaded.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.impl.HttpServerFileUploadImpl;

final class NettyFileUpload
implements FileUpload {
    private final HttpServerFileUploadImpl upload;
    private final String name;
    private String contentType;
    private String filename;
    private String contentTransferEncoding;
    private Charset charset;
    private boolean completed;
    private long maxSize = -1L;

    NettyFileUpload(HttpServerFileUploadImpl upload, String name, String filename, String contentType, String contentTransferEncoding, Charset charset) {
        this.upload = upload;
        this.name = name;
        this.filename = filename;
        this.contentType = contentType;
        this.contentTransferEncoding = contentTransferEncoding;
        this.charset = charset;
    }

    @Override
    public void setContent(ByteBuf channelBuffer) throws IOException {
        this.completed = true;
        this.upload.receiveData(Buffer.buffer(channelBuffer));
        this.upload.complete();
    }

    @Override
    public void addContent(ByteBuf channelBuffer, boolean last) throws IOException {
        this.upload.receiveData(Buffer.buffer(channelBuffer));
        if (last) {
            this.completed = true;
            this.upload.complete();
        }
    }

    @Override
    public void setContent(File file) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContent(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public long length() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long definedLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkSize(long newSize) throws IOException {
        if (this.maxSize >= 0L && newSize > this.maxSize) {
            throw new IOException("Size exceed allowed maximum capacity");
        }
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public byte[] get() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf getChunk(int i) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(Charset charset) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public boolean renameTo(File file) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    @Override
    public File getFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(InterfaceHttpData o) {
        return 0;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentTransferEncoding(String contentTransferEncoding) {
        this.contentTransferEncoding = contentTransferEncoding;
    }

    @Override
    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    @Override
    public ByteBuf getByteBuf() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileUpload copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileUpload duplicate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileUpload retainedDuplicate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileUpload replace(ByteBuf content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileUpload retain() {
        return this;
    }

    @Override
    public FileUpload retain(int increment) {
        return this;
    }

    @Override
    public FileUpload touch(Object hint) {
        return this;
    }

    @Override
    public FileUpload touch() {
        return this;
    }

    @Override
    public ByteBuf content() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int refCnt() {
        return 1;
    }

    @Override
    public boolean release() {
        return false;
    }

    @Override
    public boolean release(int decrement) {
        return false;
    }
}

