/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl.headers;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import znaishaded.io.netty.handler.codec.http.HttpHeaders;
import znaishaded.io.netty.util.AsciiString;
import znaishaded.io.netty.util.HashingStrategy;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.http.impl.HttpUtils;

public class VertxHttpHeaders
extends HttpHeaders
implements MultiMap {
    private final MapEntry[] entries = new MapEntry[16];
    private final MapEntry head;

    private MultiMap set0(Iterable<Map.Entry<String, String>> map) {
        this.clear();
        for (Map.Entry<String, String> entry : map) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap setAll(MultiMap headers) {
        return this.set0(headers);
    }

    @Override
    public MultiMap setAll(Map<String, String> headers) {
        return this.set0(headers.entrySet());
    }

    @Override
    public int size() {
        return this.names().size();
    }

    private static int index(int hash) {
        return hash & 0xF;
    }

    public VertxHttpHeaders() {
        this.head.before = this.head.after = (this.head = new MapEntry(-1, null, null));
    }

    @Override
    public VertxHttpHeaders add(CharSequence name, CharSequence value) {
        int h = AsciiString.hashCode(name);
        int i = VertxHttpHeaders.index(h);
        this.add0(h, i, name, value);
        return this;
    }

    @Override
    public VertxHttpHeaders add(CharSequence name, Object value) {
        return this.add(name, (CharSequence)value);
    }

    @Override
    public VertxHttpHeaders add(String name, String strVal) {
        int h = AsciiString.hashCode(name);
        int i = VertxHttpHeaders.index(h);
        this.add0(h, i, name, strVal);
        return this;
    }

    public VertxHttpHeaders add(String name, Iterable values) {
        int h = AsciiString.hashCode(name);
        int i = VertxHttpHeaders.index(h);
        for (Object vstr : values) {
            this.add0(h, i, name, (String)vstr);
        }
        return this;
    }

    @Override
    public MultiMap addAll(MultiMap headers) {
        for (Map.Entry<String, String> entry : headers.entries()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap addAll(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private void add0(int h, int i, CharSequence name, CharSequence value) {
        MapEntry newEntry;
        if (!(name instanceof AsciiString)) {
            HttpUtils.validateHeader(name);
        }
        if (!(value instanceof AsciiString)) {
            HttpUtils.validateHeader(value);
        }
        MapEntry e = this.entries[i];
        this.entries[i] = newEntry = new MapEntry(h, name, value);
        newEntry.next = e;
        newEntry.addBefore(this.head);
    }

    @Override
    public VertxHttpHeaders remove(String name) {
        Objects.requireNonNull(name, "name");
        int h = AsciiString.hashCode(name);
        int i = VertxHttpHeaders.index(h);
        this.remove0(h, i, name);
        return this;
    }

    private void remove0(int h, int i, CharSequence name) {
        MapEntry next;
        MapEntry e = this.entries[i];
        if (e == null) {
            return;
        }
        while (e.hash == h && AsciiString.contentEqualsIgnoreCase(name, e.key)) {
            e.remove();
            next = e.next;
            if (next != null) {
                this.entries[i] = next;
                e = next;
                continue;
            }
            this.entries[i] = null;
            return;
        }
        while ((next = e.next) != null) {
            if (next.hash == h && AsciiString.contentEqualsIgnoreCase(name, next.key)) {
                e.next = next.next;
                next.remove();
                continue;
            }
            e = next;
        }
    }

    @Override
    public VertxHttpHeaders set(String name, String strVal) {
        return this.set0(name, strVal);
    }

    private VertxHttpHeaders set0(CharSequence name, CharSequence strVal) {
        int h = AsciiString.hashCode(name);
        int i = VertxHttpHeaders.index(h);
        this.remove0(h, i, name);
        this.add0(h, i, name, strVal);
        return this;
    }

    public VertxHttpHeaders set(String name, Iterable values) {
        Objects.requireNonNull(values, "values");
        int h = AsciiString.hashCode(name);
        int i = VertxHttpHeaders.index(h);
        this.remove0(h, i, name);
        for (Object v : values) {
            if (v == null) break;
            this.add0(h, i, name, (String)v);
        }
        return this;
    }

    @Override
    public VertxHttpHeaders clear() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.head.before = this.head.after = this.head;
        return this;
    }

    @Override
    public boolean contains(String name, String value, boolean ignoreCase) {
        HashingStrategy<CharSequence> strategy;
        int h = AsciiString.hashCode(name);
        int i = VertxHttpHeaders.index(h);
        MapEntry e = this.entries[i];
        HashingStrategy<CharSequence> hashingStrategy = strategy = ignoreCase ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER;
        while (e != null) {
            if (e.hash == h && AsciiString.contentEqualsIgnoreCase(name, e.key) && strategy.equals(value, e.getValue())) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        HashingStrategy<CharSequence> strategy;
        int h = AsciiString.hashCode(name);
        int i = VertxHttpHeaders.index(h);
        MapEntry e = this.entries[i];
        HashingStrategy<CharSequence> hashingStrategy = strategy = ignoreCase ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER;
        while (e != null) {
            if (e.hash == h && AsciiString.contentEqualsIgnoreCase(name, e.key) && strategy.equals(value, e.getValue())) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public String get(String name) {
        return this.get((CharSequence)name);
    }

    private CharSequence get0(CharSequence name) {
        int h = AsciiString.hashCode(name);
        int i = VertxHttpHeaders.index(h);
        MapEntry e = this.entries[i];
        while (e != null) {
            if (e.hash == h && AsciiString.contentEqualsIgnoreCase(name, e.key)) {
                return e.getValue();
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public List<String> getAll(String name) {
        return this.getAll((CharSequence)name);
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<String, String>> action) {
        MapEntry e = this.head.after;
        while (e != this.head) {
            action.accept(new AbstractMap.SimpleEntry<String, String>(e.key.toString(), e.value.toString()));
            e = e.after;
        }
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        ArrayList<Map.Entry<String, String>> all = new ArrayList<Map.Entry<String, String>>(this.size());
        MapEntry e = this.head.after;
        while (e != this.head) {
            final MapEntry f = e;
            all.add(new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return f.key.toString();
                }

                @Override
                public String getValue() {
                    return f.value.toString();
                }

                @Override
                public String setValue(String value) {
                    return f.setValue(value).toString();
                }

                public String toString() {
                    return this.getKey() + ": " + this.getValue();
                }
            });
            e = e.after;
        }
        return all;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.entries().iterator();
    }

    @Override
    public boolean contains(String name) {
        return this.contains((CharSequence)name);
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public Set<String> names() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        MapEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.getKey().toString());
            e = e.after;
        }
        return names;
    }

    @Override
    public String get(CharSequence name) {
        Objects.requireNonNull(name, "name");
        CharSequence ret = this.get0(name);
        return ret != null ? ret.toString() : null;
    }

    @Override
    public List<String> getAll(CharSequence name) {
        Objects.requireNonNull(name, "name");
        LinkedList<String> values = new LinkedList<String>();
        int h = AsciiString.hashCode(name);
        int i = VertxHttpHeaders.index(h);
        MapEntry e = this.entries[i];
        while (e != null) {
            if (e.hash == h && AsciiString.contentEqualsIgnoreCase(name, e.key)) {
                values.addFirst(e.getValue().toString());
            }
            e = e.next;
        }
        return values;
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.get0(name) != null;
    }

    public VertxHttpHeaders add(CharSequence name, Iterable values) {
        String n = name.toString();
        for (Object seq : values) {
            this.add(n, seq.toString());
        }
        return this;
    }

    @Override
    public VertxHttpHeaders set(CharSequence name, CharSequence value) {
        return this.set(name.toString(), value.toString());
    }

    public VertxHttpHeaders set(CharSequence name, Iterable values) {
        this.remove(name);
        String n = name.toString();
        for (Object seq : values) {
            this.add(n, seq.toString());
        }
        return this;
    }

    @Override
    public VertxHttpHeaders remove(CharSequence name) {
        return this.remove(name.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this) {
            sb.append(entry).append('\n');
        }
        return sb.toString();
    }

    @Override
    public Integer getInt(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(CharSequence name, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short getShort(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(CharSequence name, short defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getTimeMillis(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTimeMillis(CharSequence name, long defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new Iterator<Map.Entry<CharSequence, CharSequence>>(){
            MapEntry current;
            {
                this.current = ((VertxHttpHeaders)VertxHttpHeaders.this).head.after;
            }

            @Override
            public boolean hasNext() {
                return this.current != VertxHttpHeaders.this.head;
            }

            @Override
            public Map.Entry<CharSequence, CharSequence> next() {
                MapEntry next = this.current;
                this.current = this.current.after;
                return next;
            }
        };
    }

    @Override
    public HttpHeaders add(String name, Object value) {
        return this.add((CharSequence)name, (CharSequence)value);
    }

    @Override
    public HttpHeaders addInt(CharSequence name, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders addShort(CharSequence name, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders set(String name, Object value) {
        return this.set0(name, (CharSequence)value);
    }

    @Override
    public HttpHeaders setInt(CharSequence name, int value) {
        return this.set(name, (CharSequence)Integer.toString(value));
    }

    @Override
    public HttpHeaders setShort(CharSequence name, short value) {
        throw new UnsupportedOperationException();
    }

    private static final class MapEntry
    implements Map.Entry<CharSequence, CharSequence> {
        final int hash;
        final CharSequence key;
        CharSequence value;
        MapEntry next;
        MapEntry before;
        MapEntry after;

        MapEntry(int hash, CharSequence key, CharSequence value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void addBefore(MapEntry e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            Objects.requireNonNull(value, "value");
            CharSequence oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + ": " + this.getValue();
        }
    }
}

