/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import znaishaded.io.netty.bootstrap.ServerBootstrap;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelFuture;
import znaishaded.io.netty.util.concurrent.GenericFutureListener;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.net.SocketAddress;

public class AsyncResolveConnectHelper {
    private List<Handler<AsyncResult<Channel>>> handlers = new ArrayList<Handler<AsyncResult<Channel>>>();
    private ChannelFuture future;
    private AsyncResult<Channel> result;

    public synchronized void addListener(Handler<AsyncResult<Channel>> handler) {
        if (this.result != null) {
            if (this.future != null) {
                this.future.addListener((GenericFutureListener<? extends znaishaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<znaishaded.io.netty.util.concurrent.Future>)v -> handler.handle(this.result)));
            } else {
                handler.handle(this.result);
            }
        } else {
            this.handlers.add(handler);
        }
    }

    private synchronized void handle(ChannelFuture cf, AsyncResult<Channel> res) {
        if (this.result == null) {
            for (Handler<AsyncResult<Channel>> handler : this.handlers) {
                handler.handle(res);
            }
        } else {
            throw new IllegalStateException("Already complete!");
        }
        this.future = cf;
        this.result = res;
    }

    private static void checkPort(int port2) {
        if (port2 < 0 || port2 > 65535) {
            throw new IllegalArgumentException("Invalid port " + port2);
        }
    }

    public static AsyncResolveConnectHelper doBind(VertxInternal vertx, SocketAddress socketAddress, ServerBootstrap bootstrap) {
        AsyncResolveConnectHelper asyncResolveConnectHelper = new AsyncResolveConnectHelper();
        bootstrap.channel(vertx.transport().serverChannelType(socketAddress.path() != null));
        if (socketAddress.path() != null) {
            java.net.SocketAddress converted = vertx.transport().convert(socketAddress, true);
            ChannelFuture future = bootstrap.bind(converted);
            future.addListener((GenericFutureListener<? extends znaishaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<znaishaded.io.netty.util.concurrent.Future>)f -> {
                if (f.isSuccess()) {
                    asyncResolveConnectHelper.handle(future, Future.succeededFuture(future.channel()));
                } else {
                    asyncResolveConnectHelper.handle(future, Future.failedFuture(f.cause()));
                }
            }));
        } else {
            AsyncResolveConnectHelper.checkPort(socketAddress.port());
            vertx.resolveAddress(socketAddress.host(), res -> {
                if (res.succeeded()) {
                    InetSocketAddress t = new InetSocketAddress((InetAddress)res.result(), socketAddress.port());
                    ChannelFuture future = bootstrap.bind(t);
                    future.addListener((GenericFutureListener<? extends znaishaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<znaishaded.io.netty.util.concurrent.Future>)f -> {
                        if (f.isSuccess()) {
                            asyncResolveConnectHelper.handle(future, Future.succeededFuture(future.channel()));
                        } else {
                            asyncResolveConnectHelper.handle(future, Future.failedFuture(f.cause()));
                        }
                    }));
                } else {
                    asyncResolveConnectHelper.handle(null, Future.failedFuture(res.cause()));
                }
            });
        }
        return asyncResolveConnectHelper;
    }
}

